/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseMedicineDto;
import com.equestricraft.api.common.APIMedicineDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineAccessor;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineTransformer;
import groovy.lang.Closure;

public class APIHorseMedicineDtoImpl
implements APIHorseMedicineDto {
    private final HorseMedicineAccessor horseMedicineAccessor;
    private final Medicine medicine;
    private final HorseMedicine horseMedicine;
    @Service
    private static MedicineTransformer medicineTransformer;

    public APIHorseMedicineDtoImpl(HorseMedicineAccessor horseMedicineAccessor, Medicine medicine, HorseMedicine horseMedicine) {
        this.horseMedicineAccessor = horseMedicineAccessor;
        this.medicine = medicine;
        this.horseMedicine = horseMedicine;
    }

    @Override
    public APIMedicineDto getMedicine() {
        return medicineTransformer.toApiDto(this.medicine);
    }

    @Override
    public void give(int dosages) {
        this.horseMedicineAccessor.give(this.medicine, dosages);
    }

    @Override
    public void giveAmount(int amount) {
        this.horseMedicineAccessor.giveAmount(this.medicine, amount);
    }

    @Override
    public int getDosage() {
        if (this.horseMedicine == null) {
            return 0;
        }
        return this.horseMedicineAccessor.getAmountOfMedicine(this.horseMedicine);
    }

    @Override
    public int dosage(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        if (this.horseMedicine == null) {
            return 0;
        }
        return this.horseMedicineAccessor.getAmountOfMedicineInPastDuration(this.horseMedicine.getMedicine(), duration.getDuration());
    }

    @Override
    public boolean isDailyOverdosed() {
        if (this.horseMedicine == null) {
            return false;
        }
        return this.horseMedicineAccessor.isDailyOverdosed(this.horseMedicine.getMedicine());
    }

    @Override
    public boolean isMaximumOverdosed() {
        if (this.horseMedicine == null) {
            return false;
        }
        return this.horseMedicineAccessor.isMaximumOverdosed(this.horseMedicine.getMedicine());
    }
}

