/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.api.common.APIHorseMedicineDto;
import com.equestricraft.api.common.APIHorseMedicinesDto;
import com.equestricraft.api.common.APIMedicineDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.medicine.APIHorseMedicineDtoImpl;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineAccessor;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.medicine.MedicineTransformer;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class APIHorseMedicinesDtoImpl
extends MapAdapter<APIMedicineDto, APIHorseMedicineDto>
implements APIHorseMedicinesDto {
    private final HorseMedicineAccessor horseMedicineAccessor;
    private List<HorseMedicine> horseMedicines = null;
    @Service
    private static MedicineRepository medicineRepository;
    @Service
    private static MedicineTransformer medicineTransformer;

    public APIHorseMedicinesDtoImpl(HorseMedicineAccessor horseMedicineAccessor) {
        this.horseMedicineAccessor = horseMedicineAccessor;
    }

    @Override
    public int size() {
        this.ensureMedicinesLoaded();
        return this.horseMedicines.size();
    }

    @Override
    public APIHorseMedicineDto get(Object key) {
        Medicine medicine = this.getFromKey(key);
        this.ensureMedicinesLoaded();
        HorseMedicine horseMedicine = this.horseMedicines.stream().filter(m -> m.getMedicine().equals(medicine)).findFirst().orElse(null);
        return new APIHorseMedicineDtoImpl(this.horseMedicineAccessor, medicine, horseMedicine);
    }

    private void ensureMedicinesLoaded() {
        if (this.horseMedicines != null) {
            this.horseMedicines = this.horseMedicineAccessor.getMedicines();
        }
    }

    private Medicine getFromKey(Object key) {
        if (key instanceof APIMedicineDto) {
            APIMedicineDto dto = (APIMedicineDto)key;
            return medicineTransformer.fromApiDto(dto);
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Medicine)medicineRepository.findByKey(id);
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return medicineRepository.findByIdentifier(identifier).orElseThrow();
        }
        throw new IllegalArgumentException("Invalid key provided");
    }

    @Override
    public Set<Map.Entry<APIMedicineDto, APIHorseMedicineDto>> entrySet() {
        this.ensureMedicinesLoaded();
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<APIMedicineDto, APIHorseMedicineDto>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<APIMedicineDto, APIHorseMedicineDto>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return APIHorseMedicinesDtoImpl.this.horseMedicines.size();
        }

        final class EntrySetIterator
        implements Iterator<Map.Entry<APIMedicineDto, APIHorseMedicineDto>> {
            private final Iterator<HorseMedicine> iterator;

            EntrySetIterator() {
                this.iterator = APIHorseMedicinesDtoImpl.this.horseMedicines.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Map.Entry<APIMedicineDto, APIHorseMedicineDto> next() {
                HorseMedicine next = this.iterator.next();
                Medicine medicine = next.getMedicine();
                APIHorseMedicineDtoImpl dto = new APIHorseMedicineDtoImpl(APIHorseMedicinesDtoImpl.this.horseMedicineAccessor, medicine, next);
                return Map.entry(dto.getMedicine(), dto);
            }
        }
    }
}

