/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.medicine.HorseMedicineAdapter;
import com.equestricraft.core.horse.medicine.HorseMedicineKey;
import com.equestricraft.core.horse.medicine.HorseMedicineRepository;
import java.util.Objects;

public class HorseMedicine
extends HorseMedicineAdapter
implements RepositoryEntity<HorseMedicineKey> {
    private final HorseMedicineKey key;
    private long expiry;

    public HorseMedicine(int horseId, int medicineId, long expiry) {
        this.key = new HorseMedicineKey(horseId, medicineId);
        this.expiry = expiry;
    }

    @Override
    public HorseMedicineKey getKey() {
        return this.key;
    }

    public int getHorseId() {
        return this.getKey().horseId();
    }

    @Override
    public int getMedicineId() {
        return this.getKey().medicineId();
    }

    public long getExpiry() {
        return this.expiry;
    }

    public void setExpiry(long expiry) {
        this.expiry = expiry;
    }

    @Override
    public void save() {
        Services.getService(HorseMedicineRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseMedicine that = (HorseMedicine)o;
        return Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public String toString() {
        return this.getKey().horseId() + " - " + this.getKey().medicineId();
    }
}

