/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineDetails;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.core.horse.medicine.HorseMedicineRepository;
import com.equestricraft.core.horse.medicine.HorseMedicineSession;
import com.equestricraft.core.horse.medicine.MedicineGiveResponse;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.category.MedicineCategory;
import java.time.Duration;
import java.util.List;

public class HorseMedicineAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseMedicineSession horseMedicineSession;
    @Service
    private static HorseMedicineRepository horseMedicineRepository;

    public HorseMedicineAccessor(EQHorse horse) {
        super(horse);
    }

    public void give(Medicine medicine, int dosages) {
        for (int i = 0; i < dosages; ++i) {
            horseMedicineSession.giveMedicineToHorse(medicine, this.horse);
        }
    }

    public MedicineGiveResponse giveAmount(Medicine medicine, int amount) {
        return horseMedicineSession.giveMedicineToHorse(medicine, this.horse, amount);
    }

    public List<HorseMedicine> getMedicines() {
        return horseMedicineRepository.findByHorse(this.horse.getId());
    }

    public int getAmountOfMedicineCategoryInHorse(MedicineCategory medicineCategory) {
        return horseMedicineSession.getAmountOfMedicineCategoryInHorse(medicineCategory, this.horse.getId());
    }

    public int getAmountOfMedicineCategoryInHorse(MedicineCategory medicineCategory, Duration duration) {
        return horseMedicineSession.getAmountOfMedicineCategoryInPastDuration(medicineCategory, this.horse.getId(), duration);
    }

    public List<HorseMedicineInformation> getCurrentMedicineInformation() {
        return horseMedicineSession.getHorsesCurrentMedicineInformation(this.horse.getId());
    }

    public List<HorseMedicineDetails> getCurrentMedicineDetails() {
        return horseMedicineSession.getHorsesCurrentMedicineDetails(this.horse.getId());
    }

    public int getAmountOfMedicine(HorseMedicine horseMedicine) {
        return horseMedicineSession.getAmountOfMedicine(horseMedicine);
    }

    public int getAmountOfMedicineInPastDuration(Medicine medicine, Duration duration) {
        return horseMedicineSession.getAmountOfMedicineInPastDuration(medicine, this.horse.getId(), duration);
    }

    public boolean isMaximumOverdosed(Medicine medicine) {
        return horseMedicineSession.isHorseMaximumOverdoseForMedicine(this.horse.getId(), medicine);
    }

    public boolean isDailyOverdosed(Medicine medicine) {
        return horseMedicineSession.isHorseDailyOverdoseForMedicine(this.horse.getId(), medicine);
    }
}

