/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineKey;
import java.util.List;

public class HorseMedicineDatabase
implements RepositoryDatasource<HorseMedicine, HorseMedicineKey> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_MEDICINE_ID = "MEDICINE_ID";
    private static final String COLUMN_EXPIRY = "EXPIRY";

    @Override
    public void create(HorseMedicine horseMedicine) {
        Query.insertInto("HORSE_MEDICINE").columns(QueryColumn.column(COLUMN_HORSE_ID, horseMedicine.getHorseId()), QueryColumn.column(COLUMN_MEDICINE_ID, horseMedicine.getMedicineId()), QueryColumn.column(COLUMN_EXPIRY, horseMedicine.getExpiry())).execute();
    }

    @Override
    public List<HorseMedicine> retrieveAll() {
        return Query.selectAllFrom("HORSE_MEDICINE").getList(this::getFromResultRow);
    }

    private HorseMedicine getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int medicineId = row.getInt(COLUMN_MEDICINE_ID);
        long expiry = row.getLong(COLUMN_EXPIRY);
        return new HorseMedicine(horseId, medicineId, expiry);
    }

    @Override
    public void update(HorseMedicine horseMedicine) {
        Query.update("HORSE_MEDICINE").set(QueryColumn.column(COLUMN_EXPIRY, horseMedicine.getExpiry())).where(QueryColumn.column(COLUMN_HORSE_ID, horseMedicine.getHorseId()), QueryColumn.column(COLUMN_MEDICINE_ID, horseMedicine.getMedicineId())).execute();
    }
}

