/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineDatabase;
import com.equestricraft.core.horse.medicine.HorseMedicineKey;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class HorseMedicineRepository
extends Repository<HorseMedicine, HorseMedicineKey> {
    @Service
    private HorseMedicineDatabase horseMedicineDatabase;

    @Override
    protected RepositoryDatasource<HorseMedicine, HorseMedicineKey> getDatasource() {
        return this.horseMedicineDatabase;
    }

    @Override
    protected Function<HorseMedicine, Object> getIndexFunction() {
        return HorseMedicine::getHorseId;
    }

    public Optional<HorseMedicine> findByHorseAndMedicine(int horseId, int medicineId) {
        return this.findByKeyIfExists(new HorseMedicineKey(horseId, medicineId));
    }

    public List<HorseMedicine> findByHorse(int horseId) {
        return this.findListByIndexKey(horseId);
    }
}

