/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.illness.IllnessHorse;
import com.equestricraft.core.horse.medicine.HorseMedicine;
import com.equestricraft.core.horse.medicine.HorseMedicineAdapter;
import com.equestricraft.core.horse.medicine.HorseMedicineDetails;
import com.equestricraft.core.horse.medicine.HorseMedicineInformation;
import com.equestricraft.core.horse.medicine.HorseMedicineRepository;
import com.equestricraft.core.horse.medicine.HorseMedicineSession;
import com.equestricraft.core.horse.medicine.MedicineGiveResponse;
import com.equestricraft.core.horse.medicine.log.HorseMedicineLog;
import com.equestricraft.core.horse.medicine.log.HorseMedicineLogRepository;
import com.equestricraft.core.illness.IllnessMedicine;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.medicine.Medicine;
import com.equestricraft.core.medicine.MedicineConflict;
import com.equestricraft.core.medicine.MedicineRepository;
import com.equestricraft.core.medicine.category.MedicineCategory;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.ToDoubleFunction;

public class HorseMedicineSessionImpl
implements HorseMedicineSession {
    @Service
    private HorseMedicineRepository horseMedicineRepository;
    @Service
    private HorseMedicineLogRepository horseMedicineLogRepository;
    @Service
    private MedicineRepository medicineRepository;

    @Override
    public MedicineGiveResponse giveMedicineToHorse(Medicine medicine, EQHorse horse, int dosageSize) {
        long now = System.currentTimeMillis();
        for (ItemTag tag : medicine.getTags()) {
            double value;
            if (tag.getRejectThreshold() == null || !((value = horse.getTags().getValueForTag(tag.getTagId())) <= tag.getRejectThreshold())) continue;
            return new MedicineGiveResponse(medicine.getId(), medicine.getName(), 0, 0);
        }
        this.logMedicineTaken(medicine.getId(), horse.getId(), dosageSize, now);
        float unitsGiven = (float)dosageSize / (float)medicine.getSingleDosageSize();
        this.updateHorseMedicineRecord(medicine, horse, unitsGiven, now);
        this.updateIllnessCureProcess(medicine, horse, unitsGiven);
        int recommendedDaysUntilBooster = this.calculateRecommendedDaysUntilBooster(medicine);
        for (ItemTag tag : medicine.getTags()) {
            horse.getTags().offsetValueForTag(tag.getTagId(), tag.getOffsetValue());
        }
        return new MedicineGiveResponse(medicine.getId(), medicine.getName(), dosageSize, recommendedDaysUntilBooster);
    }

    private void logMedicineTaken(int medicineId, int horseId, int dosage, long now) {
        HorseMedicineLog log = new HorseMedicineLog(0, horseId, medicineId, now, dosage);
        this.horseMedicineLogRepository.add(log);
    }

    private void updateHorseMedicineRecord(Medicine medicine, EQHorse horse, float unitsGiven, long now) {
        long totalDoseDurationMillis = (long)medicine.getSingleDosageDurationDays() + 86400000L;
        long millisToAdd = (long)((float)totalDoseDurationMillis * unitsGiven);
        Optional<HorseMedicine> existing = this.horseMedicineRepository.findByHorseAndMedicine(horse.getId(), medicine.getId());
        if (existing.isPresent()) {
            long newExpiry = existing.get().getExpiry() + millisToAdd;
            existing.get().setExpiry(newExpiry);
            existing.get().save();
        } else {
            long expiry = now + millisToAdd;
            HorseMedicine newRecord = new HorseMedicine(horse.getId(), medicine.getId(), expiry);
            this.horseMedicineRepository.add(newRecord);
        }
    }

    private void updateIllnessCureProcess(Medicine medicine, EQHorse horse, float unitsGiven) {
        List<IllnessHorse> illnessRecords = horse.getIllness().getUncured();
        illnessRecords.stream().flatMap(r -> r.getIllness().getMedicines().stream()).filter(im -> im.getMedicine().equals(medicine)).filter(IllnessMedicine::affectsCuring).filter(im -> this.canMedicineApplyRightNow(medicine, horse, (IllnessMedicine)im)).forEach(im -> {
            int percentage = (int)((double)(unitsGiven / (float)im.getUnitsNeeded()) * 100.0);
            horse.getIllness().increaseCurePercentage(im.getIllness(), percentage);
        });
    }

    private boolean canMedicineApplyRightNow(Medicine medicine, EQHorse horse, IllnessMedicine im) {
        if (im.getDelayBetweenUnitsHours() == 0) {
            return true;
        }
        double unitsGivenInDuration = this.getUnitsGivenOfMedicineInPastDuration(horse, medicine, Duration.ofHours(im.getDelayBetweenUnitsHours()));
        return unitsGivenInDuration < 1.0;
    }

    private double getUnitsGivenOfMedicineInPastDuration(EQHorse horse, Medicine medicine, Duration duration) {
        List<HorseMedicineLog> logs = this.horseMedicineLogRepository.findByHorseAndMedicineSinceTime(horse.getId(), medicine.getId(), DateUtils.futureDurationOffset(duration.negated()).getTime());
        double total = logs.stream().mapToDouble(HorseMedicineLog::getAmount).sum();
        return total / (double)medicine.getSingleDosageSize();
    }

    private int calculateRecommendedDaysUntilBooster(Medicine medicine) {
        return PercentageUtils.decreaseByPercentage(medicine.getSingleDosageDurationDays(), medicine.getBoosterEffectivenessThresholdPercentage());
    }

    private int getAmountOfMedicineInHorse(int medicineId, int horseId) {
        Optional<HorseMedicine> horseMedicine = this.horseMedicineRepository.findByHorseAndMedicine(horseId, medicineId);
        return horseMedicine.map(this::getAmountOfMedicine).orElse(0);
    }

    @Override
    public int getAmountOfMedicine(HorseMedicine horseMedicine) {
        return this.getAmount(horseMedicine);
    }

    @Override
    public int getAmountOfMedicineCategoryInHorse(MedicineCategory medicineCategory, int horseId) {
        List<Medicine> medicines = this.medicineRepository.findMedicinesByMedicineCategory(medicineCategory.getId());
        return medicines.stream().mapToInt(m -> this.getAmountOfMedicineInHorse(m.getId(), horseId)).sum();
    }

    private int getAmount(HorseMedicine horseMedicine) {
        Medicine medicine = horseMedicine.getMedicine();
        long millisRemaining = DateUtils.millisUntil(horseMedicine.getExpiry());
        long singleDosageDurationMillis = (long)medicine.getSingleDosageDurationDays() * 86400000L;
        float totalDosages = (float)((double)millisRemaining / (double)singleDosageDurationMillis);
        return (int)(totalDosages * (float)medicine.getSingleDosageSize());
    }

    @Override
    public int getAmountOfMedicineInPastDuration(Medicine medicine, int horseId, Duration duration) {
        Date earliestTime = DateUtils.futureDurationOffset(duration.negated());
        return this.getAmountOfMedicineForHorseSinceTime(medicine, horseId, earliestTime);
    }

    @Override
    public int getAmountOfMedicineCategoryInPastDuration(MedicineCategory medicineCategory, int horseId, Duration duration) {
        Date earliestTime = DateUtils.futureDurationOffset(duration.negated());
        List<Medicine> medicines = this.medicineRepository.findMedicinesByMedicineCategory(medicineCategory.getId());
        return medicines.stream().mapToInt(m -> this.getAmountOfMedicineForHorseSinceTime((Medicine)m, horseId, earliestTime)).sum();
    }

    private Integer getAmountOfMedicineForHorseSinceTime(Medicine medicine, int horseId, Date time) {
        List<HorseMedicineLog> records = this.horseMedicineLogRepository.findByHorseAndMedicineSinceTime(horseId, medicine.getId(), time.getTime());
        return records.stream().mapToInt(HorseMedicineLog::getAmount).sum();
    }

    @Override
    public float getSpeedOffsetFactor(EQHorse horse) {
        return (float)this.getStatPercentageFromMedicine(horse, Medicine::getMaximumOverdoseSpeedPercentage, Medicine::getDailyOverdoseSpeedPercentage, MedicineConflict::getSpeedPercentage) / 100.0f;
    }

    @Override
    public float getJumpOffsetFactor(EQHorse horse) {
        return (float)this.getStatPercentageFromMedicine(horse, Medicine::getMaximumOverdoseJumpPercentage, Medicine::getDailyOverdoseJumpPercentage, MedicineConflict::getJumpPercentage) / 100.0f;
    }

    private double getStatPercentageFromMedicine(EQHorse horse, ToDoubleFunction<Medicine> maximumOverdoseProvider, ToDoubleFunction<Medicine> dailyOverdoseProvider, ToDoubleFunction<MedicineConflict> conflictProvider) {
        List<Medicine> medicines = this.medicineRepository.findAll();
        return NumberUtils.min(this.getStatPercentageFromMaximumOverdose(horse, medicines, maximumOverdoseProvider), this.getStatPercentageFromDailyOverdose(horse, medicines, dailyOverdoseProvider), this.getStatPercentageFromConflict(horse, conflictProvider));
    }

    private double getStatPercentageFromMaximumOverdose(EQHorse horse, List<Medicine> medicines, ToDoubleFunction<Medicine> percentageProvider) {
        return medicines.stream().mapToDouble(medicine -> {
            int amount;
            int startDelta;
            Optional<HorseMedicine> horseMedicine = this.horseMedicineRepository.findByHorseAndMedicine(horse.getId(), medicine.getId());
            if (horseMedicine.isPresent() && (startDelta = (amount = this.getAmount(horseMedicine.get())) - medicine.getMaximumOverdoseStartSize()) > 0) {
                int totalMaximumOverdoseLength = medicine.getMaximumOverdoseEndSize() - medicine.getMaximumOverdoseStartSize();
                double percentageThroughMaximumOverdose = (double)startDelta / (double)totalMaximumOverdoseLength * 100.0;
                return PercentageUtils.of(percentageProvider.applyAsDouble((Medicine)medicine), percentageThroughMaximumOverdose);
            }
            return 100.0;
        }).max().orElse(100.0);
    }

    private double getStatPercentageFromDailyOverdose(EQHorse horse, List<Medicine> medicines, ToDoubleFunction<Medicine> percentageProvider) {
        return medicines.stream().filter(m -> {
            int pastDayAmount = this.getAmountOfMedicineInPastDuration((Medicine)m, horse.getId(), Duration.ofDays(1L));
            return pastDayAmount > m.getDailyOverdoseSize();
        }).mapToDouble(percentageProvider).max().orElse(100.0);
    }

    private double getStatPercentageFromConflict(EQHorse horse, ToDoubleFunction<MedicineConflict> percentageProvider) {
        List<HorseMedicine> records = this.horseMedicineRepository.findByHorse(horse.getId());
        return records.stream().map(HorseMedicineAdapter::getMedicine).flatMap(m -> m.getMedicineConflicts().stream()).filter(c -> ListUtils.containsByPredicate(records, r -> r.getMedicineId() == c.getMedicineId())).distinct().mapToDouble(percentageProvider).max().orElse(100.0);
    }

    @Override
    public List<HorseMedicineInformation> getHorsesCurrentMedicineInformation(int horseId) {
        List<HorseMedicine> medicines = this.horseMedicineRepository.findByHorse(horseId);
        return medicines.stream().map(horseMedicine -> {
            Medicine medicine = horseMedicine.getMedicine();
            int amount = this.getAmount((HorseMedicine)horseMedicine);
            int percentage = (int)((double)amount / (double)medicine.getMaximumEffectiveness() * 100.0);
            boolean boosterRecommended = percentage < medicine.getBoosterEffectivenessThresholdPercentage();
            boolean dailyOverdose = percentage > medicine.getDailyOverdoseSize();
            boolean maximumOverdose = percentage > medicine.getMaximumOverdoseStartSize();
            return new HorseMedicineInformation(medicine.getId(), medicine.getName(), medicine.getDescription(), amount, medicine.getDosageUnitName(), boosterRecommended, dailyOverdose, maximumOverdose);
        }).toList();
    }

    @Override
    public List<HorseMedicineDetails> getHorsesCurrentMedicineDetails(int horseId) {
        List<HorseMedicine> medicines = this.horseMedicineRepository.findByHorse(horseId);
        return medicines.stream().map(horseMedicine -> {
            int amount = this.getAmount((HorseMedicine)horseMedicine);
            return new HorseMedicineDetails(horseMedicine.getMedicine(), amount);
        }).toList();
    }

    @Override
    public float getHorsesEffectivenessForMedicine(int horseId, Medicine medicine) {
        Optional<HorseMedicine> horseMedicine = this.horseMedicineRepository.findByHorseAndMedicine(horseId, medicine.getId());
        if (horseMedicine.isPresent()) {
            int amount = this.getAmount(horseMedicine.get());
            float percentage = (float)amount / (float)medicine.getMaximumEffectiveness();
            return NumberUtils.keepWithinRange(Float.valueOf(percentage), Float.valueOf(0.0f), Float.valueOf(1.0f)).floatValue();
        }
        return 0.0f;
    }

    @Override
    public boolean isHorseMaximumOverdoseForMedicine(int horseId, Medicine medicine) {
        int amount = this.getAmountOfMedicineInHorse(medicine.getId(), horseId);
        return amount >= medicine.getMaximumOverdoseStartSize();
    }

    @Override
    public boolean isHorseDailyOverdoseForMedicine(int horseId, Medicine medicine) {
        int dailyAmount = this.getAmountOfMedicineInPastDuration(medicine, horseId, Duration.ofDays(1L));
        return dailyAmount >= medicine.getDailyOverdoseSize();
    }
}

