/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.medicine.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.medicine.log.HorseMedicineLog;
import java.util.List;

public class HorseMedicineLogDatabase
implements RepositoryDatasource<HorseMedicineLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_MEDICINE_ID = "MEDICINE_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_AMOUNT = "AMOUNT";

    @Override
    public void create(HorseMedicineLog horseMedicineLog) {
        Query.insertInto("HORSE_MEDICINE_LOG").columns(QueryColumn.column(COLUMN_HORSE_ID, horseMedicineLog.getHorseId()), QueryColumn.column(COLUMN_MEDICINE_ID, horseMedicineLog.getMedicineId()), QueryColumn.column(COLUMN_TIME_STAMP, horseMedicineLog.getTimeStamp()), QueryColumn.column(COLUMN_AMOUNT, horseMedicineLog.getAmount())).executeGetGeneratedKey(horseMedicineLog::setId);
    }

    @Override
    public List<HorseMedicineLog> retrieveAll() {
        return Query.selectAllFrom("HORSE_MEDICINE_LOG").getList(this::getFromResultRow);
    }

    private HorseMedicineLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int medicineId = row.getInt(COLUMN_MEDICINE_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        int amount = row.getInt(COLUMN_AMOUNT);
        return new HorseMedicineLog(id, horseId, medicineId, timeStamp, amount);
    }
}

