/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.memory;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.memory.MemoryStatProvider;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;

public class MemoryTrait
implements Trait {
    @Service
    private ServiceInstance<MemoryStatProvider> memoryStatProviders;

    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.memory.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.memory.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public float getValue(EQHorse horse) {
        return this.memoryStatProviders.stream().map(p -> Float.valueOf(p.getMemoryOffsetValue(horse))).collect(ECCollectors.toCombinedFloatPercentage(this.getBaseValue(horse))).floatValue();
    }

    private float getBaseValue(EQHorse horse) {
        float baseValue = horse.getBaseMemory().getValue().floatValue();
        double age = horse.getAge().getYears();
        if (age < 2.0) {
            return baseValue * 0.6f;
        }
        if (age >= 25.0) {
            return baseValue * 0.7f;
        }
        return baseValue;
    }
}

