/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.metabolism;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.metabolism.HorseMetabolismStatProvider;

public class HorseMetabolismAccessor
extends AbstractHorseAccessor {
    @Service
    private static ServiceInstance<HorseMetabolismStatProvider> horseMetabolismStatProviders;

    public HorseMetabolismAccessor(EQHorse horse) {
        super(horse);
    }

    public float getValue() {
        Float metabolismPercentage = horseMetabolismStatProviders.stream().map(p -> Float.valueOf(p.getMetabolismFactor(this.horse))).collect(ECCollectors.toCombinedFloatPercentage(this.horse.getBaseMetabolismPercentage().getValue().floatValue() / 100.0f));
        return Math.max(metabolismPercentage.floatValue(), 0.0f);
    }
}

