/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.microchip;

import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseMicrochipAccessor
extends AbstractHorseAccessor {
    public HorseMicrochipAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean isMicrochipped() {
        return this.horse.getMicrochipDate() != null;
    }

    public void setMicrochipped(boolean microChipped) {
        if (microChipped) {
            this.horse.setMicrochipDate(new Date());
        } else {
            this.horse.setMicrochipDate(null);
        }
        this.horse.save();
    }

    public Optional<Duration> getDurationSinceMicrochipped() {
        Date date = this.horse.getMicrochipDate();
        if (date == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationSince(date));
    }
}

