/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.movement;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseMovementDto;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.horse.movement.HorseMovementAccessor;
import groovy.lang.Closure;

public class APIHorseMovementDtoImpl
implements APIHorseMovementDto {
    private final HorseMovementAccessor horseMovementAccessor;

    public APIHorseMovementDtoImpl(HorseMovementAccessor horseMovementAccessor) {
        this.horseMovementAccessor = horseMovementAccessor;
    }

    @Override
    public Double getIndex() {
        return this.horseMovementAccessor.getMovementIndex().orElse(null);
    }

    @Override
    public Double index(APIDurationDto duration) {
        return this.horseMovementAccessor.getDistanceFromPastDuration(duration.getDuration());
    }

    @Override
    public Double index(Closure<?> config) {
        APIDurationDto duration = new APIDurationDto();
        config.setDelegate(duration);
        config.call();
        return this.index(duration);
    }

    @Override
    public double getDistance() {
        return this.horseMovementAccessor.getDistance();
    }

    @Override
    public double distance(APIDurationDto duration) {
        return this.horseMovementAccessor.getDistanceFromPastDuration(duration.getDuration());
    }

    @Override
    public double distance(Closure<?> config) {
        APIDurationDto duration = new APIDurationDto();
        config.setDelegate(duration);
        config.call();
        return this.distance(duration);
    }

    public String toString() {
        Double value = this.getIndex();
        if (value == null) {
            return StringUtils.emptyString();
        }
        return value.toString();
    }
}

