/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.movement;

import com.equestricraft.common.coordinate.Coordinate;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.movement.HorseMovementContainer;
import java.time.Duration;
import java.util.List;
import java.util.Optional;

public class HorseMovementAccessor
extends AbstractHorseAccessor {
    private final HorseMovementContainer container = new HorseMovementContainer();
    private long lastMovementRecord = 0L;

    public HorseMovementAccessor(EQHorse horse) {
        super(horse);
    }

    public void addMovementCoordinate(Coordinate coordinate) {
        if (DateUtils.minutesSince(this.lastMovementRecord) > 2) {
            this.container.addMovement(coordinate);
            this.lastMovementRecord = System.currentTimeMillis();
        }
    }

    public Optional<Double> getMovementIndex() {
        List<Coordinate> movements = this.container.getAllMovements();
        return this.getIndexFromCoordinates(movements);
    }

    public Optional<Double> getMovementIndexFromPastDuration(Duration duration) {
        List<Coordinate> movements = this.container.getMovementsSince(DateUtils.futureDurationOffset(duration.negated()).getTime());
        return this.getIndexFromCoordinates(movements);
    }

    private Optional<Double> getIndexFromCoordinates(List<Coordinate> movements) {
        if (movements.size() < 50) {
            return Optional.empty();
        }
        List<Double> xValues = movements.stream().mapToDouble(Coordinate::x).boxed().toList();
        List<Double> zValues = movements.stream().mapToDouble(Coordinate::z).boxed().toList();
        double x1 = (Double)xValues.stream().min(Double::compare).orElseThrow();
        double x2 = (Double)xValues.stream().max(Double::compare).orElseThrow();
        double z1 = (Double)zValues.stream().min(Double::compare).orElseThrow();
        double z2 = (Double)zValues.stream().max(Double::compare).orElseThrow();
        double dx = x2 - x1;
        double dz = z2 - z1;
        return Optional.of((dx + dz) / 2.0);
    }

    public double getDistance() {
        return this.container.getDistance();
    }

    public double getDistanceFromPastDuration(Duration duration) {
        return this.container.getDistanceSince(DateUtils.futureDurationOffset(duration.negated()).getTime());
    }
}

