/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.movement;

import com.equestricraft.common.coordinate.Coordinate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class HorseMovementContainer {
    private static final int MAX_SIZE = 100;
    private final Map<Long, Coordinate> movements = new LinkedHashMap<Long, Coordinate>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, Coordinate> eldest) {
            return this.size() > 100;
        }
    };
    private final StampedLock lock = new StampedLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMovement(Coordinate coordinate) {
        long stamp = this.lock.writeLock();
        try {
            this.movements.put(System.currentTimeMillis(), coordinate);
        }
        finally {
            this.lock.unlockWrite(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Coordinate> getAllMovements() {
        long stamp = this.lock.readLock();
        try {
            ArrayList<Coordinate> arrayList = new ArrayList<Coordinate>(this.movements.values());
            return arrayList;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Coordinate> getMovementsSince(long timeStamp) {
        long stamp = this.lock.readLock();
        try {
            List<Coordinate> list = this.movements.entrySet().stream().filter(e -> (Long)e.getKey() >= timeStamp).map(Map.Entry::getValue).toList();
            return list;
        }
        finally {
            this.lock.unlockRead(stamp);
        }
    }

    public double getDistance() {
        return this.countDistance(this.getAllMovements());
    }

    public double getDistanceSince(long timeStamp) {
        List<Coordinate> validMovements = this.getMovementsSince(timeStamp);
        return this.countDistance(validMovements);
    }

    private double countDistance(List<Coordinate> coordinates) {
        double total = 0.0;
        Coordinate last = null;
        for (Coordinate coordinate : coordinates) {
            if (last != null) {
                total += last.distanceTo(coordinate);
            }
            last = coordinate;
        }
        return total;
    }
}

