/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.name;

import com.equestricraft.cdi.Services;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerService;
import java.util.Objects;

public record HorseNameKey(ECPlayer player, String name) {
    private static final String DELIMIT_CHARACTER = ":";

    public HorseNameKey {
        Objects.requireNonNull(name, "Must provide a value for the name");
    }

    public static HorseNameKey fromStringWithDefaultPlayer(ECPlayer player, String providedString) {
        if (providedString.contains(DELIMIT_CHARACTER)) {
            String[] parts = providedString.split(DELIMIT_CHARACTER);
            String playerIgn = parts[0];
            String name = parts[1].toLowerCase();
            PlayerService playerService = Services.getService(PlayerService.class);
            CorePlayer keyPlayer = playerService.retrievePlayerByIgn(playerIgn);
            return new HorseNameKey(keyPlayer, name);
        }
        return new HorseNameKey(player, providedString);
    }
}

