/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.name;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ApplicationConstants;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.common.StringCheck;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseConstants;
import com.equestricraft.core.horse.HorseNotFoundException;
import com.equestricraft.core.horse.name.HorseNameKey;
import com.equestricraft.core.horse.name.HorseNameService;
import com.equestricraft.core.horse.name.HorseNameValidationException;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyRepository;
import com.equestricraft.core.player.ECPlayer;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HorseNameServiceImpl
implements HorseNameService {
    @Service
    private PregnancyRepository pregnancyRepository;
    @Service
    private BlockedPhraseService blockedPhraseService;

    @Override
    public Optional<EQHorse> findHorseByNameKey(HorseNameKey horseNameKey) {
        return this.findLivingByPlayerAndName(horseNameKey.player(), horseNameKey.name());
    }

    @Override
    public EQHorse requireHorseByNameKey(HorseNameKey horseNameKey) {
        return this.findHorseByNameKey(horseNameKey).orElseThrow(() -> new HorseNotFoundException(I18n.getLabel("horse.not-found.name", horseNameKey.name())));
    }

    @Override
    public String ensureValidForPlayer(ECPlayer player, String name) throws HorseNameValidationException {
        return this.ensureValidForPlayer(player, name, true);
    }

    @Override
    public String ensureValidForPlayer(ECPlayer player, String name, boolean checkDuplicates) throws HorseNameValidationException {
        Objects.requireNonNull(name);
        name = name.trim();
        name = ColorsHelper.stripColorsAndFormatting(name);
        if (name.length() > HorseConstants.MAXIMUM_NAME_LENGTH) {
            throw new HorseNameValidationException(I18n.getLabel("horse.name.validation.too-long", HorseConstants.MAXIMUM_NAME_LENGTH));
        }
        if (!StringCheck.isAlphanumericWithoutSpaces(name)) {
            throw new HorseNameValidationException(I18n.getLabel("horse.name.validation.invalid-character"));
        }
        if (checkDuplicates && this.isPlayerUsingName(player, name)) {
            throw new HorseNameValidationException(I18n.getLabel("horse.name.validation.already-in-use"));
        }
        if (this.blockedPhraseService.containsBlockedPhrase(name)) {
            throw new HorseNameValidationException(I18n.getLabel("horse.name.validation.blocked-phrase"));
        }
        return name;
    }

    @Override
    public String generateAutoIncrementingNameForPlayer(ECPlayer player) {
        List<EQHorse> livingHorses = player.getHorses().getLiving();
        List<Pregnancy> activePregnancies = this.pregnancyRepository.findPregnanciesByOwnerAndStatus(player.getId(), PregnancyStatus.PREGNANT);
        String ignPart = player.getIgn().replaceAll("[^a-zA-Z0-9]", "");
        for (int number = 1; number <= ApplicationConstants.AUTO_INCREMENTING_HORSE_PLAYER_NAME_LIMIT; ++number) {
            String name = String.format("%s%s", ignPart, number);
            boolean horseFoundUsingName = this.doAnyHorsesContainName(livingHorses, name);
            boolean pregnancyFoundUsingName = this.doAnyPregnanciesContainName(activePregnancies, name);
            if (horseFoundUsingName || pregnancyFoundUsingName) continue;
            return name;
        }
        throw new IllegalArgumentException(String.format("Could not generate a horse name for player %s", player.getIgn()));
    }

    @Override
    public boolean isPlayerUsingName(ECPlayer player, String name) {
        Optional<EQHorse> horseWithName = this.findLivingByPlayerAndName(player, name);
        if (horseWithName.isPresent()) {
            return true;
        }
        List<Pregnancy> activePregnancies = this.pregnancyRepository.findPregnanciesByOwnerAndStatus(player.getId(), PregnancyStatus.PREGNANT);
        return this.doAnyPregnanciesContainName(activePregnancies, name);
    }

    public Optional<EQHorse> findLivingByPlayerAndName(ECPlayer player, String name) {
        return player.getHorses().getLiving().stream().filter(h -> h.getName().equalsIgnoreCase(name)).findFirst();
    }

    private boolean doAnyHorsesContainName(List<EQHorse> livingHorses, String name) {
        return livingHorses.stream().anyMatch(h -> h.getName().equalsIgnoreCase(name));
    }

    private boolean doAnyPregnanciesContainName(List<Pregnancy> activePregnancies, String name) {
        return activePregnancies.stream().flatMap(p -> p.getHorses().stream()).filter(ph -> ph.getName() != null).anyMatch(ph -> ph.getName().equalsIgnoreCase(name));
    }
}

