/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.nutrient;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.nutrient.HorseNutrition;
import java.util.List;

public class HorseNutritionDatabase
implements RepositoryDatasource<HorseNutrition, Integer> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_VITAMIN_A = "VITAMIN_A";
    private static final String COLUMN_VITAMIN_B1 = "VITAMIN_B1";
    private static final String COLUMN_VITAMIN_B2 = "VITAMIN_B2";
    private static final String COLUMN_VITAMIN_B3 = "VITAMIN_B3";
    private static final String COLUMN_VITAMIN_B5 = "VITAMIN_B5";
    private static final String COLUMN_VITAMIN_B6 = "VITAMIN_B6";
    private static final String COLUMN_VITAMIN_B7 = "VITAMIN_B7";
    private static final String COLUMN_VITAMIN_B9 = "VITAMIN_B9";
    private static final String COLUMN_VITAMIN_B12 = "VITAMIN_B12";
    private static final String COLUMN_VITAMIN_C = "VITAMIN_C";
    private static final String COLUMN_VITAMIN_D = "VITAMIN_D";
    private static final String COLUMN_VITAMIN_E = "VITAMIN_E";
    private static final String COLUMN_VITAMIN_K = "VITAMIN_K";
    private static final String COLUMN_PROTEIN = "PROTEIN";
    private static final String COLUMN_FIBER = "FIBER";
    private static final String COLUMN_MINERALS = "MINERALS";
    private static final String COLUMN_CARBS = "CARBS";
    private static final String COLUMN_FLUIDS = "FLUIDS";
    private static final String COLUMN_FAT = "FAT";
    private static final String COLUMN_ELECTROLYTE = "ELECTROLYTE";
    private static final String COLUMN_SUGAR = "SUGAR";

    @Override
    public void create(HorseNutrition horseNutrition) {
        Query.insertInto("HORSE_NUTRITION").columns(QueryColumn.column(COLUMN_HORSE_ID, horseNutrition.getHorseId()), QueryColumn.column(COLUMN_VITAMIN_A, horseNutrition.getVitaminA()), QueryColumn.column(COLUMN_VITAMIN_B1, horseNutrition.getVitaminB1()), QueryColumn.column(COLUMN_VITAMIN_B2, horseNutrition.getVitaminB2()), QueryColumn.column(COLUMN_VITAMIN_B3, horseNutrition.getVitaminB3()), QueryColumn.column(COLUMN_VITAMIN_B5, horseNutrition.getVitaminB5()), QueryColumn.column(COLUMN_VITAMIN_B6, horseNutrition.getVitaminB6()), QueryColumn.column(COLUMN_VITAMIN_B7, horseNutrition.getVitaminB7()), QueryColumn.column(COLUMN_VITAMIN_B9, horseNutrition.getVitaminB9()), QueryColumn.column(COLUMN_VITAMIN_B12, horseNutrition.getVitaminB12()), QueryColumn.column(COLUMN_VITAMIN_C, horseNutrition.getVitaminC()), QueryColumn.column(COLUMN_VITAMIN_D, horseNutrition.getVitaminD()), QueryColumn.column(COLUMN_VITAMIN_E, horseNutrition.getVitaminE()), QueryColumn.column(COLUMN_VITAMIN_K, horseNutrition.getVitaminK()), QueryColumn.column(COLUMN_PROTEIN, horseNutrition.getProtein()), QueryColumn.column(COLUMN_FIBER, horseNutrition.getFiber()), QueryColumn.column(COLUMN_MINERALS, horseNutrition.getMinerals()), QueryColumn.column(COLUMN_CARBS, horseNutrition.getCarbs()), QueryColumn.column(COLUMN_FLUIDS, horseNutrition.getFluids()), QueryColumn.column(COLUMN_FAT, horseNutrition.getFat()), QueryColumn.column(COLUMN_ELECTROLYTE, horseNutrition.getElectrolyte()), QueryColumn.column(COLUMN_SUGAR, horseNutrition.getSugar())).execute();
    }

    @Override
    public List<HorseNutrition> retrieveAll() {
        return Query.selectAllFrom("HORSE_NUTRITION").getList(this::getFromResultRow);
    }

    private HorseNutrition getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        double vitaminA = row.getDouble(COLUMN_VITAMIN_A);
        double vitaminB1 = row.getDouble(COLUMN_VITAMIN_B1);
        double vitaminB2 = row.getDouble(COLUMN_VITAMIN_B2);
        double vitaminB3 = row.getDouble(COLUMN_VITAMIN_B3);
        double vitaminB5 = row.getDouble(COLUMN_VITAMIN_B5);
        double vitaminB6 = row.getDouble(COLUMN_VITAMIN_B6);
        double vitaminB7 = row.getDouble(COLUMN_VITAMIN_B7);
        double vitaminB9 = row.getDouble(COLUMN_VITAMIN_B9);
        double vitaminB12 = row.getDouble(COLUMN_VITAMIN_B12);
        double vitaminC = row.getDouble(COLUMN_VITAMIN_C);
        double vitaminD = row.getDouble(COLUMN_VITAMIN_D);
        double vitaminE = row.getDouble(COLUMN_VITAMIN_E);
        double vitaminK = row.getDouble(COLUMN_VITAMIN_K);
        double protein = row.getDouble(COLUMN_PROTEIN);
        double fiber = row.getDouble(COLUMN_FIBER);
        double minerals = row.getDouble(COLUMN_MINERALS);
        double carbs = row.getDouble(COLUMN_CARBS);
        double fluids = row.getDouble(COLUMN_FLUIDS);
        double fat = row.getDouble(COLUMN_FAT);
        double electrolyte = row.getDouble(COLUMN_ELECTROLYTE);
        double sugar = row.getDouble(COLUMN_SUGAR);
        return new HorseNutrition(horseId, vitaminA, vitaminB1, vitaminB2, vitaminB3, vitaminB5, vitaminB6, vitaminB7, vitaminB9, vitaminB12, vitaminC, vitaminD, vitaminE, vitaminK, protein, fiber, minerals, carbs, fluids, fat, electrolyte, sugar);
    }

    @Override
    public void update(HorseNutrition horseNutrition) {
        Query.update("HORSE_NUTRITION").set(QueryColumn.column(COLUMN_VITAMIN_A, horseNutrition.getVitaminA()), QueryColumn.column(COLUMN_VITAMIN_B1, horseNutrition.getVitaminB1()), QueryColumn.column(COLUMN_VITAMIN_B2, horseNutrition.getVitaminB2()), QueryColumn.column(COLUMN_VITAMIN_B3, horseNutrition.getVitaminB3()), QueryColumn.column(COLUMN_VITAMIN_B5, horseNutrition.getVitaminB5()), QueryColumn.column(COLUMN_VITAMIN_B6, horseNutrition.getVitaminB6()), QueryColumn.column(COLUMN_VITAMIN_B7, horseNutrition.getVitaminB7()), QueryColumn.column(COLUMN_VITAMIN_B9, horseNutrition.getVitaminB9()), QueryColumn.column(COLUMN_VITAMIN_B12, horseNutrition.getVitaminB12()), QueryColumn.column(COLUMN_VITAMIN_C, horseNutrition.getVitaminC()), QueryColumn.column(COLUMN_VITAMIN_D, horseNutrition.getVitaminD()), QueryColumn.column(COLUMN_VITAMIN_E, horseNutrition.getVitaminE()), QueryColumn.column(COLUMN_VITAMIN_K, horseNutrition.getVitaminK()), QueryColumn.column(COLUMN_PROTEIN, horseNutrition.getProtein()), QueryColumn.column(COLUMN_FIBER, horseNutrition.getFiber()), QueryColumn.column(COLUMN_MINERALS, horseNutrition.getMinerals()), QueryColumn.column(COLUMN_CARBS, horseNutrition.getCarbs()), QueryColumn.column(COLUMN_FLUIDS, horseNutrition.getFluids()), QueryColumn.column(COLUMN_FAT, horseNutrition.getFat()), QueryColumn.column(COLUMN_ELECTROLYTE, horseNutrition.getElectrolyte()), QueryColumn.column(COLUMN_SUGAR, horseNutrition.getSugar())).where(QueryColumn.column(COLUMN_HORSE_ID, horseNutrition.getHorseId())).execute();
    }
}

