/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.nutrient;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.Range;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.nutrient.HorseNutrientInfo;
import com.equestricraft.core.horse.nutrient.HorseNutrientStatus;
import com.equestricraft.core.horse.nutrient.HorseNutrition;
import com.equestricraft.core.horse.nutrient.HorseNutritionRepository;
import com.equestricraft.core.horse.nutrient.HorseNutritionSession;
import com.equestricraft.core.nutrient.Nutrient;

public class HorseNutritionSessionImpl
implements HorseNutritionSession {
    @Service
    private HorseNutritionRepository horseNutritionRepository;
    @Service
    private HorseRepository horseRepository;

    @Override
    public double getValueForNutrient(int horseId, Nutrient nutrient) {
        HorseNutrition horseNutrition = this.horseNutritionRepository.findNutrientsByHorse(horseId);
        return this.getNutritionValueFromHorseNutrition(horseNutrition, nutrient);
    }

    @Override
    public String getDisplayValueForNutrient(int horseId, Nutrient nutrient) {
        double value = this.getValueForNutrient(horseId, nutrient);
        return String.format("%s%s", value, nutrient.getUnit());
    }

    @Override
    public HorseNutrientInfo getInfoForNutrient(int horseId, Nutrient nutrient) {
        double value = this.getValueForNutrient(horseId, nutrient);
        String displayValue = String.format("%s%s", value, nutrient.getUnit());
        HorseNutrientStatus status = this.getNutrientStatus(horseId, value, nutrient);
        return new HorseNutrientInfo(nutrient, value, displayValue, status);
    }

    private HorseNutrientStatus getNutrientStatus(int horseId, double value, Nutrient nutrient) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        Range<Double> targetRange = nutrient.getRangeForAge(horse.getAge().getMonths());
        if (targetRange.valueBelowRange(value)) {
            return HorseNutrientStatus.NOT_ENOUGH;
        }
        if (targetRange.valueAboveRange(value)) {
            return HorseNutrientStatus.TOO_MUCH;
        }
        return HorseNutrientStatus.GOOD;
    }

    @Override
    public double getNutritionValueFromHorseNutrition(HorseNutrition horseNutrition, Nutrient nutrient) {
        return switch (nutrient) {
            default -> throw new IncompatibleClassChangeError();
            case Nutrient.VITAMIN_A -> horseNutrition.getVitaminA();
            case Nutrient.VITAMIN_B1 -> horseNutrition.getVitaminB1();
            case Nutrient.VITAMIN_B2 -> horseNutrition.getVitaminB2();
            case Nutrient.VITAMIN_B3 -> horseNutrition.getVitaminB3();
            case Nutrient.VITAMIN_B5 -> horseNutrition.getVitaminB5();
            case Nutrient.VITAMIN_B6 -> horseNutrition.getVitaminB6();
            case Nutrient.VITAMIN_B7 -> horseNutrition.getVitaminB7();
            case Nutrient.VITAMIN_B9 -> horseNutrition.getVitaminB9();
            case Nutrient.VITAMIN_B12 -> horseNutrition.getVitaminB12();
            case Nutrient.VITAMIN_C -> horseNutrition.getVitaminC();
            case Nutrient.VITAMIN_D -> horseNutrition.getVitaminD();
            case Nutrient.VITAMIN_E -> horseNutrition.getVitaminE();
            case Nutrient.VITAMIN_K -> horseNutrition.getVitaminK();
            case Nutrient.PROTEIN -> horseNutrition.getProtein();
            case Nutrient.FIBER -> horseNutrition.getFiber();
            case Nutrient.MINERALS -> horseNutrition.getMinerals();
            case Nutrient.CARBS -> horseNutrition.getCarbs();
            case Nutrient.FLUIDS -> horseNutrition.getFluids();
            case Nutrient.FAT -> horseNutrition.getFat();
            case Nutrient.ELECTROLYTE -> horseNutrition.getElectrolyte();
            case Nutrient.SUGAR -> horseNutrition.getSugar();
        };
    }

    @Override
    public double getHorsesCalories(int horseId) {
        HorseNutrition horseNutrition = this.horseNutritionRepository.findNutrientsByHorse(horseId);
        return Nutrient.getOrderedWithCalories().stream().mapToDouble(n -> this.getNutritionValueFromHorseNutrition(horseNutrition, (Nutrient)((Object)n)) * n.getCaloriesPerUnit()).sum();
    }
}

