/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.nutrient;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.gait.Halt;
import com.equestricraft.core.horse.gait.HorseSubGait;
import com.equestricraft.core.horse.nutrient.DefaultNutrientValueMapping;
import com.equestricraft.core.horse.nutrient.HorseNutrientStatProvider;
import com.equestricraft.core.horse.nutrient.HorseNutrition;
import com.equestricraft.core.horse.nutrient.HorseNutritionRepository;
import com.equestricraft.core.horse.nutrient.HorseNutritionSession;
import com.equestricraft.core.horse.nutrient.HorseNutritionUpdateSession;
import com.equestricraft.core.horse.nutrient.NutrientValueMapping;
import com.equestricraft.core.horse.ride.HorseGaitTimes;
import com.equestricraft.core.horse.weather.HorseWeatherSession;
import com.equestricraft.core.nutrient.Nutrient;
import java.time.Duration;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;

public class HorseNutritionUpdateSessionImpl
implements HorseNutritionUpdateSession {
    @Service
    private HorseNutritionRepository horseNutritionRepository;
    @Service
    private HorseNutritionSession horseNutritionSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private HorseWeatherSession horseWeatherSession;
    @Service
    private ServiceInstance<HorseNutrientStatProvider> horseNutrientStatProviders;

    @Override
    public void initialiseHorsesNutrients(int horseId) {
        HorseNutrition horseNutrition = new HorseNutrition(horseId, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.horseNutritionRepository.add(horseNutrition);
    }

    @Override
    public void giveNutrientsToHorse(int horseId, List<? extends NutrientValueMapping> requests) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        HorseNutrition horseNutrition = this.horseNutritionRepository.findNutrientsByHorse(horseId);
        requests.forEach(r -> this.giveNutrientToHorseNutrition(horse, horseNutrition, r.getNutrient(), r.getValue()));
    }

    @Override
    public void takeNutrientsForIdleHours(EQHorse horse, double idleHours) {
        double minutes = idleHours * 60.0;
        double perMinute = this.getCaloriesForSpeed(Halt.DEFAULT);
        double caloriesToRemove = minutes * perMinute;
        this.removeCalories(horse, caloriesToRemove);
    }

    @Override
    public void takeNutrientsForSpeeds(EQHorse horse, HorseGaitTimes gaitTimes) {
        double caloriesToRemove = gaitTimes.entrySet().stream().mapToDouble(me -> (double)((Duration)me.getValue()).toMinutes() * this.getCaloriesForSpeed((HorseSubGait)me.getKey())).sum();
        this.removeCalories(horse, caloriesToRemove);
    }

    private double getCaloriesForSpeed(HorseSubGait gait) {
        double calories = gait.getMainGait().getCaloriesPerMinute();
        double percentageFromWeather = this.horseWeatherSession.getCaloriesBurnPercentageOffset();
        return PercentageUtils.of(calories, percentageFromWeather);
    }

    private void removeCalories(EQHorse horse, double caloriesToRemove) {
        List<Nutrient> nutrients = Nutrient.getOrderedWithCalories();
        HorseNutrition horseNutrition = this.horseNutritionRepository.findNutrientsByHorse(horse.getId());
        LinkedList<DefaultNutrientValueMapping> updateRequests = new LinkedList<DefaultNutrientValueMapping>();
        for (Nutrient nutrient : nutrients) {
            double valueForNutrient = this.horseNutritionSession.getNutritionValueFromHorseNutrition(horseNutrition, nutrient);
            double caloriesForNutrient = valueForNutrient + nutrient.getCaloriesPerUnit();
            double caloriesToRemoveForThisNutrient = Math.min(caloriesForNutrient, caloriesToRemove);
            double valueToRemoveForNutrient = caloriesToRemoveForThisNutrient / nutrient.getCaloriesPerUnit();
            updateRequests.add(new DefaultNutrientValueMapping(nutrient, valueToRemoveForNutrient));
            if (!((caloriesToRemove -= caloriesToRemoveForThisNutrient) <= 0.0)) continue;
            break;
        }
        this.takeNutrientFromHorse(horse, updateRequests);
    }

    private void takeNutrientFromHorse(EQHorse horse, List<? extends NutrientValueMapping> requests) {
        HorseNutrition horseNutrition = this.horseNutritionRepository.findNutrientsByHorse(horse.getId());
        requests.forEach(r -> this.takeNutrientFromHorseNutrition(horseNutrition, r.getNutrient(), r.getValue(), horse));
    }

    private void giveNutrientToHorseNutrition(EQHorse horse, HorseNutrition horseNutrition, Nutrient nutrient, double value) {
        if ((value = HorseNutritionUpdateSessionImpl.ensureNotNegative(value)) == 0.0) {
            return;
        }
        this.offsetValueForNutrition(horseNutrition, nutrient, value, horse);
    }

    private void takeNutrientFromHorseNutrition(HorseNutrition horseNutrition, Nutrient nutrient, double value, EQHorse horse) {
        value = HorseNutritionUpdateSessionImpl.ensureNotNegative(value);
        this.offsetValueForNutrition(horseNutrition, nutrient, -value, horse);
        this.updateLastNutritionReductionDate(horseNutrition);
    }

    private static double ensureNotNegative(double value) {
        return Math.max(0.0, value);
    }

    private void updateLastNutritionReductionDate(HorseNutrition horseNutrition) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseNutrition.getHorseId());
        horse.setLastNutritionReduction(new Date());
        horse.save();
    }

    private void offsetValueForNutrition(HorseNutrition horseNutrition, Nutrient nutrient, double value, EQHorse horse) {
        switch (nutrient) {
            case VITAMIN_A: {
                this.offsetValue(value, horseNutrition::getVitaminA, horseNutrition::setVitaminA, nutrient, horse);
                break;
            }
            case VITAMIN_B1: {
                this.offsetValue(value, horseNutrition::getVitaminB1, horseNutrition::setVitaminB1, nutrient, horse);
                break;
            }
            case VITAMIN_B2: {
                this.offsetValue(value, horseNutrition::getVitaminB2, horseNutrition::setVitaminB2, nutrient, horse);
                break;
            }
            case VITAMIN_B3: {
                this.offsetValue(value, horseNutrition::getVitaminB3, horseNutrition::setVitaminB3, nutrient, horse);
                break;
            }
            case VITAMIN_B5: {
                this.offsetValue(value, horseNutrition::getVitaminB5, horseNutrition::setVitaminB5, nutrient, horse);
                break;
            }
            case VITAMIN_B6: {
                this.offsetValue(value, horseNutrition::getVitaminB6, horseNutrition::setVitaminB6, nutrient, horse);
                break;
            }
            case VITAMIN_B7: {
                this.offsetValue(value, horseNutrition::getVitaminB7, horseNutrition::setVitaminB7, nutrient, horse);
                break;
            }
            case VITAMIN_B9: {
                this.offsetValue(value, horseNutrition::getVitaminB9, horseNutrition::setVitaminB9, nutrient, horse);
                break;
            }
            case VITAMIN_B12: {
                this.offsetValue(value, horseNutrition::getVitaminB12, horseNutrition::setVitaminB12, nutrient, horse);
                break;
            }
            case VITAMIN_C: {
                this.offsetValue(value, horseNutrition::getVitaminC, horseNutrition::setVitaminC, nutrient, horse);
                break;
            }
            case VITAMIN_D: {
                this.offsetValue(value, horseNutrition::getVitaminD, horseNutrition::setVitaminD, nutrient, horse);
                break;
            }
            case VITAMIN_E: {
                this.offsetValue(value, horseNutrition::getVitaminE, horseNutrition::setVitaminE, nutrient, horse);
                break;
            }
            case VITAMIN_K: {
                this.offsetValue(value, horseNutrition::getVitaminK, horseNutrition::setVitaminK, nutrient, horse);
                break;
            }
            case PROTEIN: {
                this.offsetValue(value, horseNutrition::getProtein, horseNutrition::setProtein, nutrient, horse);
                break;
            }
            case FIBER: {
                this.offsetValue(value, horseNutrition::getFiber, horseNutrition::setFiber, nutrient, horse);
                break;
            }
            case MINERALS: {
                this.offsetValue(value, horseNutrition::getMinerals, horseNutrition::setMinerals, nutrient, horse);
                break;
            }
            case CARBS: {
                this.offsetValue(value, horseNutrition::getCarbs, horseNutrition::setCarbs, nutrient, horse);
                break;
            }
            case FLUIDS: {
                this.offsetValue(value, horseNutrition::getFluids, horseNutrition::setFluids, nutrient, horse);
                break;
            }
            case FAT: {
                this.offsetValue(value, horseNutrition::getFat, horseNutrition::setFat, nutrient, horse);
                break;
            }
            case ELECTROLYTE: {
                this.offsetValue(value, horseNutrition::getElectrolyte, horseNutrition::setElectrolyte, nutrient, horse);
                break;
            }
            case SUGAR: {
                this.offsetValue(value, horseNutrition::getSugar, horseNutrition::setSugar, nutrient, horse);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid nutrient type: %s", nutrient.name()));
            }
        }
        horseNutrition.save();
    }

    private void offsetValue(double value, DoubleSupplier currentValueFunction, DoubleConsumer repoUpdate, Nutrient nutrient, EQHorse horse) {
        double currentValue = currentValueFunction.getAsDouble();
        double newValue = Math.max(currentValue + value, 0.0);
        Float factor = this.horseNutrientStatProviders.stream().map(p -> Float.valueOf(p.getFactorFromNutrient(horse, nutrient))).collect(ECCollectors.toCombinedFloatPercentage());
        repoUpdate.accept(newValue * (double)factor.floatValue());
    }
}

