/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.obedience;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.ProbabilityUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseSettings;
import com.equestricraft.core.horse.obedience.HorseObedienceSession;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.featureflag.FeatureFlag;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.StampedLock;

public class HorseObedienceAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseObedienceSession horseObedienceSession;
    private final ObeyCheckFailures obeyCheckFailures = new ObeyCheckFailures();

    public HorseObedienceAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean shouldObey(ECPlayer player) {
        if (FeatureFlag.TRUST_OBEY.isDisabled()) {
            return true;
        }
        double obediencePercentage = this.getObediencePercentage(player);
        boolean shouldObey = ProbabilityUtils.testPercentageProbability(obediencePercentage += this.getIncreaseFromRepeating(player));
        if (shouldObey) {
            this.obeyCheckFailures.resetFailCount(player);
        } else {
            this.obeyCheckFailures.increaseFailCount(player);
        }
        return shouldObey;
    }

    private double getIncreaseFromRepeating(ECPlayer player) {
        Integer checksSinceLastSuccess = this.obeyCheckFailures.getChecksSinceLastSuccess(player);
        return (double)checksSinceLastSuccess.intValue() * HorseSettings.getObedienceIncreasePerRepeatingCommand();
    }

    public double getObediencePercentage(ECPlayer player) {
        return horseObedienceSession.getHorsesObediencePercentageWithPlayer(this.horse, player);
    }

    private static class ObeyCheckFailures {
        private final Map<Integer, Integer> playerObeyFails = new HashMap<Integer, Integer>(0);
        private final StampedLock lock = new StampedLock();

        private ObeyCheckFailures() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Integer getChecksSinceLastSuccess(ECPlayer player) {
            long stamp = this.lock.readLock();
            try {
                Integer n = this.playerObeyFails.getOrDefault(player.getId(), 0);
                return n;
            }
            finally {
                this.lock.unlockRead(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetFailCount(ECPlayer player) {
            long stamp = this.lock.writeLock();
            try {
                this.playerObeyFails.remove(player.getId());
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void increaseFailCount(ECPlayer player) {
            long stamp = this.lock.writeLock();
            try {
                Integer current = this.playerObeyFails.getOrDefault(player.getId(), 0);
                this.playerObeyFails.put(player.getId(), current + 1);
            }
            finally {
                this.lock.unlockWrite(stamp);
            }
        }
    }
}

