/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.obedience;

import com.equestricraft.cdi.Service;
import com.equestricraft.cdi.ServiceInstance;
import com.equestricraft.common.collector.ECCollectors;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.obedience.ObedienceProvider;
import com.equestricraft.core.horse.trait.Trait;
import com.equestricraft.core.horse.trait.TraitVisitor;

public class ObedienceTrait
implements Trait {
    @Service
    private static ServiceInstance<ObedienceProvider> obedienceProviders;

    @Override
    public float getValue(EQHorse horse) {
        return obedienceProviders.stream().map(p -> Float.valueOf(p.getOffsetValue(horse))).collect(ECCollectors.toCombinedFloatPercentage(this.getCoreValue(horse))).floatValue();
    }

    private float getCoreValue(EQHorse horse) {
        return horse.getAge().getYears() >= 8.0 ? 1.5f : 0.5f;
    }

    @Override
    public String getName() {
        return I18n.getLabel("horse.trait.obedient.name");
    }

    @Override
    public String getDescription() {
        return I18n.getLabel("horse.trait.obedient.description");
    }

    @Override
    public <T> T accept(TraitVisitor<T> visitor) {
        return visitor.visit(this);
    }
}

