/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.operation;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseOperationDto;
import com.equestricraft.api.common.APIOperationDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.operation.HorseOperationAccessor;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationTransformer;
import groovy.lang.Closure;
import java.time.Duration;
import java.util.Optional;

public class APIHorseOperationDtoImpl
implements APIHorseOperationDto {
    private final HorseOperationAccessor horseOperationAccessor;
    private final Operation operation;
    @Service
    private static OperationTransformer operationTransformer;

    public APIHorseOperationDtoImpl(HorseOperationAccessor horseOperationAccessor, Operation operation) {
        this.horseOperationAccessor = horseOperationAccessor;
        this.operation = operation;
    }

    @Override
    public APIOperationDto getOperation() {
        return operationTransformer.toDto(this.operation);
    }

    @Override
    public APIDurationDto getDurationSinceLastPerformed() {
        Optional<Duration> duration = this.horseOperationAccessor.getDurationSinceOperationLastPerformed(this.operation);
        return duration.map(APIDurationDto::new).orElse(null);
    }

    @Override
    public Integer count(APIDurationDto duration) {
        return this.horseOperationAccessor.getCountInPastDuration(this.operation, duration.getDuration());
    }

    @Override
    public Integer count(Closure<?> closure) {
        APIDurationDto duration = new APIDurationDto();
        closure.setDelegate(duration);
        closure.call();
        return this.count(duration);
    }
}

