/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.operation;

import com.equestricraft.api.common.APIHorseOperationDto;
import com.equestricraft.api.common.APIHorseOperationsDto;
import com.equestricraft.api.common.APIOperationDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.MapAdapter;
import com.equestricraft.core.horse.operation.APIHorseOperationDtoImpl;
import com.equestricraft.core.horse.operation.HorseOperationAccessor;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.OperationRepository;
import com.equestricraft.core.operation.OperationTransformer;

public class APIHorseOperationsDtoImpl
extends MapAdapter<APIOperationDto, APIHorseOperationDto>
implements APIHorseOperationsDto {
    private final HorseOperationAccessor horseOperationAccessor;
    @Service
    private static OperationTransformer operationTransformer;
    @Service
    private static OperationRepository operationRepository;

    public APIHorseOperationsDtoImpl(HorseOperationAccessor horseOperationAccessor) {
        this.horseOperationAccessor = horseOperationAccessor;
    }

    @Override
    public APIHorseOperationDto get(Object key) {
        Operation operation = this.getFromKey(key);
        return new APIHorseOperationDtoImpl(this.horseOperationAccessor, operation);
    }

    private Operation getFromKey(Object key) {
        if (key instanceof APIOperationDto) {
            APIOperationDto dto = (APIOperationDto)key;
            return operationTransformer.fromDto(dto);
        }
        if (key instanceof String) {
            String identifier = (String)key;
            return operationRepository.findByIdentifier(identifier).orElseThrow();
        }
        if (key instanceof Integer) {
            Integer id = (Integer)key;
            return (Operation)operationRepository.findByKey(id);
        }
        throw new IllegalArgumentException("Invalid operation key");
    }
}

