/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.operation;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.operation.Operation;
import com.equestricraft.core.operation.log.OperationLogSession;
import java.time.Duration;
import java.util.Date;
import java.util.Optional;

public class HorseOperationAccessor
extends AbstractHorseAccessor {
    @Service
    private static OperationLogSession operationLogSession;

    public HorseOperationAccessor(EQHorse horse) {
        super(horse);
    }

    public Optional<Duration> getDurationSinceOperationLastPerformed(Operation operation) {
        Optional<Date> time = operationLogSession.getTimeOperationWasLastPerformed(this.horse.getId(), operation.getId());
        return time.map(DateUtils::durationSince);
    }

    public Integer getCountInPastDuration(Operation operation, Duration duration) {
        return operationLogSession.getCountOfOperationForHorseInDuration(operation.getId(), this.horse.getId(), duration);
    }
}

