/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.permission;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.access.HorsePlayerAccessSession;
import com.equestricraft.core.horse.permission.HorsePermissionException;
import com.equestricraft.core.horse.permission.HorsePermissionLevel;
import com.equestricraft.core.player.ECPlayer;

public class HorsePermissionChecker {
    @Service
    private static HorsePlayerAccessSession horsePlayerAccessSession;

    public static boolean hasPermissionLevel(ECPlayer player, EQHorse horse, HorsePermissionLevel level) {
        if (player.getPermission().hasPermission("equestricraft.horse.access-other-player")) {
            return true;
        }
        HorsePermissionLevel currentLevel = HorsePermissionChecker.getPlayersPermissionLevel(player, horse);
        return currentLevel.isAtLeast(level);
    }

    public static void ensureHasPermissionLevel(ECPlayer player, EQHorse horse, HorsePermissionLevel level) {
        if (!HorsePermissionChecker.hasPermissionLevel(player, horse, level)) {
            throw new HorsePermissionException();
        }
    }

    public static HorsePermissionLevel getPlayersPermissionLevel(ECPlayer player, EQHorse horse) {
        if (horse.getOwnerId() == player.getId()) {
            return HorsePermissionLevel.OWNER;
        }
        if (horsePlayerAccessSession.isPlayerAddedToHorseAccessList(player, horse.getId())) {
            return HorsePermissionLevel.BASIC;
        }
        return HorsePermissionLevel.NONE;
    }

    private HorsePermissionChecker() {
    }
}

