/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorsePregnancyDto;
import com.equestricraft.api.common.APIPregnancyDto;
import com.equestricraft.api.common.APIPregnancySearchDto;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.core.horse.pregnancy.APIPregnancyDtoImpl;
import com.equestricraft.core.horse.pregnancy.HorsePregnancyAccessor;
import com.equestricraft.core.horse.pregnancy.UltrasoundInfo;
import groovy.lang.Closure;
import java.time.Duration;
import java.util.Optional;

public class APIHorsePregnancyDtoImpl
implements APIHorsePregnancyDto {
    private final HorsePregnancyAccessor horsePregnancyAccessor;

    public APIHorsePregnancyDtoImpl(HorsePregnancyAccessor horsePregnancyAccessor) {
        this.horsePregnancyAccessor = horsePregnancyAccessor;
    }

    @Override
    public boolean isPregnant() {
        return this.horsePregnancyAccessor.isPregnant();
    }

    @Override
    public APIPregnancyDto getCurrent() {
        Optional<UltrasoundInfo> pregnancy = this.horsePregnancyAccessor.getUltrasound();
        return pregnancy.map(p -> new APIPregnancyDtoImpl(this.horsePregnancyAccessor, (UltrasoundInfo)p)).orElse(null);
    }

    @Override
    public int count(Closure<?> config) {
        SearchDetails details = new SearchDetails();
        config.setDelegate(details);
        config.call();
        return this.horsePregnancyAccessor.retrievePregnanciesForHorseWithStatusInPastDuration(details.status, details.duration).size();
    }

    public String toString() {
        return this.isPregnant() ? "Pregnant" : "Not Pregnant";
    }

    private static class SearchDetails
    implements APIPregnancySearchDto {
        private PregnancyStatus status = null;
        private Duration duration = null;

        private SearchDetails() {
        }

        @Override
        public void status(String status) {
            this.status = PregnancyStatus.valueOf(status);
        }

        @Override
        public void duration(Closure<?> closure) {
            APIDurationDto d = new APIDurationDto();
            closure.setDelegate(d);
            closure.call();
            this.duration(d);
        }

        @Override
        public void duration(APIDurationDto duration) {
            this.duration = duration.getDuration();
        }
    }
}

