/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.api.common.APIDurationDto;
import com.equestricraft.api.common.APIHorseDto;
import com.equestricraft.api.common.APIPregnancyDto;
import com.equestricraft.api.common.APIResponse;
import com.equestricraft.api.common.APIUltrasoundHorseDto;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.pregnancy.HorsePregnancyAccessor;
import com.equestricraft.core.horse.pregnancy.PregnancyException;
import com.equestricraft.core.horse.pregnancy.PregnancyTransformer;
import com.equestricraft.core.horse.pregnancy.UltrasoundInfo;
import java.time.Duration;
import java.util.Date;
import java.util.List;

public class APIPregnancyDtoImpl
implements APIPregnancyDto {
    private final HorsePregnancyAccessor horsePregnancyAccessor;
    private final UltrasoundInfo ultrasoundInfo;
    @Service
    private static PregnancyTransformer pregnancyTransformer;

    public APIPregnancyDtoImpl(HorsePregnancyAccessor horsePregnancyAccessor, UltrasoundInfo ultrasoundInfo) {
        this.horsePregnancyAccessor = horsePregnancyAccessor;
        this.ultrasoundInfo = ultrasoundInfo;
    }

    @Override
    public int getId() {
        return this.ultrasoundInfo.id();
    }

    @Override
    public boolean isMiscarried() {
        return this.ultrasoundInfo.miscarried();
    }

    @Override
    public APIHorseDto getMother() {
        return new APIHorseDtoImpl(this.ultrasoundInfo.mother());
    }

    @Override
    public APIHorseDto getFather() {
        return new APIHorseDtoImpl(this.ultrasoundInfo.father());
    }

    @Override
    public Date getEstimatedDueDate() {
        return this.ultrasoundInfo.estimatedDueDate();
    }

    @Override
    public APIDurationDto getEstimatedDurationLeft() {
        Duration duration = DateUtils.durationUntil(this.getEstimatedDueDate());
        return new APIDurationDto(duration);
    }

    @Override
    public APIDurationDto getDurationSinceStart() {
        Duration duration = DateUtils.durationSince(this.ultrasoundInfo.startTime());
        return new APIDurationDto(duration);
    }

    @Override
    public List<APIUltrasoundHorseDto> getFoals() {
        List<UltrasoundInfo.UltrasoundHorseInfo> horses = this.ultrasoundInfo.horses();
        return pregnancyTransformer.toUltrasoundHorseDtoList(horses);
    }

    @Override
    public Integer getFoalsCount() {
        return this.ultrasoundInfo.horses().size();
    }

    @Override
    public boolean getKnown() {
        return this.horsePregnancyAccessor.isPregnancyAware();
    }

    @Override
    public void setKnown(boolean known) {
        this.horsePregnancyAccessor.setPregnancyAware(known);
    }

    @Override
    public APIResponse complete() {
        try {
            this.horsePregnancyAccessor.completePregnancy();
            return APIResponse.success();
        }
        catch (PregnancyException ex) {
            return APIResponse.fail();
        }
    }

    @Override
    public APIResponse abort() {
        try {
            this.horsePregnancyAccessor.abortPregnancy();
            return APIResponse.success();
        }
        catch (PregnancyException ex) {
            return APIResponse.fail();
        }
    }

    @Override
    public APIResponse miscarry() {
        try {
            this.horsePregnancyAccessor.miscarryPregnancy();
            return APIResponse.success();
        }
        catch (PregnancyException ex) {
            return APIResponse.fail();
        }
    }

    @Override
    public APIResponse stillborn() {
        try {
            this.horsePregnancyAccessor.stillbornPregnancy();
            return APIResponse.success();
        }
        catch (PregnancyException ex) {
            return APIResponse.fail();
        }
    }
}

