/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyException;
import com.equestricraft.core.horse.pregnancy.PregnancyInfo;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.horse.pregnancy.UltrasoundInfo;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class HorsePregnancyAccessor
extends AbstractHorseAccessor {
    @Service
    private static PregnancySession pregnancySession;

    public HorsePregnancyAccessor(EQHorse horse) {
        super(horse);
    }

    public boolean isPregnant() {
        return pregnancySession.isHorseCurrentlyPregnant(this.horse);
    }

    public Optional<UltrasoundInfo> getUltrasound() {
        return pregnancySession.getUltrasound(this.horse);
    }

    public Optional<Duration> getDurationHorseHasBeenPregnant() {
        return pregnancySession.retrieveDurationHorseHasBeenPregnantFor(this.horse);
    }

    public boolean isPregnancyAware() {
        return this.horse.getPregnancyAwareTime() != null;
    }

    public void setPregnancyAware(boolean aware) {
        this.horse.setPregnancyAwareTime(aware ? new Date() : null);
        this.horse.save();
    }

    public void completePregnancy() throws PregnancyException {
        pregnancySession.completePregnancyForHorse(this.horse.getId());
    }

    public void abortPregnancy() throws PregnancyException {
        pregnancySession.abortPregnancyForHorse(this.horse.getId());
    }

    public void miscarryPregnancy() throws PregnancyException {
        pregnancySession.miscarryPregnancyForHorse(this.horse.getId());
    }

    public void stillbornPregnancy() throws PregnancyException {
        pregnancySession.stillbornPregnancyForHorse(this.horse.getId());
    }

    public List<Pregnancy> retrievePregnanciesForHorseWithStatusInPastDuration(PregnancyStatus status, Duration duration) {
        return pregnancySession.retrievePregnanciesForHorseWithStatusInPastDuration(this.horse.getId(), status, duration);
    }

    public Optional<PregnancyInfo> getPregnancyInfo() {
        return pregnancySession.retrievePregnancyInfoForHorse(this.horse.getId());
    }

    public Optional<Double> getPercentageThroughPregnancy() {
        return pregnancySession.calculatePercentageThroughPregnancy(this.horse);
    }
}

