/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.core.horse.pregnancy.PregnancyHorse;
import com.equestricraft.core.horse.pregnancy.PregnancyRepository;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class Pregnancy
implements RepositoryEntity<Integer> {
    private int id;
    private final int motherId;
    private final int fatherId;
    private final Date pregnancyTime;
    private final Date estimatedDueDate;
    private final Date actualDueDate;
    private final Date miscarriageDate;
    private final int ownerId;
    private PregnancyStatus status;
    private Date statusChangeDate;
    private final List<PregnancyHorse> horses;

    public Pregnancy(int id, int motherId, int fatherId, Date pregnancyTime, Date estimatedDueDate, Date actualDueDate, Date miscarriageDate, int ownerId, PregnancyStatus status, Date statusChangeDate, List<PregnancyHorse> horses) {
        this.id = id;
        this.motherId = motherId;
        this.fatherId = fatherId;
        this.pregnancyTime = pregnancyTime;
        this.estimatedDueDate = estimatedDueDate;
        this.actualDueDate = actualDueDate;
        this.miscarriageDate = miscarriageDate;
        this.ownerId = ownerId;
        this.status = status;
        this.statusChangeDate = statusChangeDate;
        this.horses = horses;
    }

    @Override
    public Integer getKey() {
        return this.getId();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getMotherId() {
        return this.motherId;
    }

    public int getFatherId() {
        return this.fatherId;
    }

    public Date getPregnancyTime() {
        return this.pregnancyTime;
    }

    public Date getEstimatedDueDate() {
        return this.estimatedDueDate;
    }

    public Date getActualDueDate() {
        return this.actualDueDate;
    }

    public Date getMiscarriageDate() {
        return this.miscarriageDate;
    }

    public int getOwnerId() {
        return this.ownerId;
    }

    public PregnancyStatus getStatus() {
        return this.status;
    }

    public void setStatus(PregnancyStatus status) {
        this.status = status;
    }

    public Date getStatusChangeDate() {
        return this.statusChangeDate;
    }

    public void setStatusChangeDate(Date statusChangeDate) {
        this.statusChangeDate = statusChangeDate;
    }

    public List<PregnancyHorse> getHorses() {
        return this.horses;
    }

    @Override
    public void save() {
        Services.getService(PregnancyRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pregnancy pregnancy = (Pregnancy)o;
        return this.id == pregnancy.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

