/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyHorse;
import java.sql.Date;
import java.util.List;

public class PregnancyDatabase
implements RepositoryDatasource<Pregnancy, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_MOTHER_ID = "MOTHER_ID";
    private static final String COLUMN_FATHER_ID = "FATHER_ID";
    private static final String COLUMN_PREGNANCY_TIME = "PREGNANCY_TIME";
    private static final String COLUMN_ESTIMATED_DUE_DATE = "ESTIMATED_DUE_DATE";
    private static final String COLUMN_ACTUAL_DUE_DATE = "ACTUAL_DUE_DATE";
    private static final String COLUMN_MISCARRIAGE_DATE = "MISCARRIAGE_DATE";
    private static final String COLUMN_OWNER_ID = "OWNER_ID";
    private static final String COLUMN_STATUS = "STATUS";
    private static final String COLUMN_STATUS_CHANGE_DATE = "STATUS_CHANGE_DATE";
    private static final String COLUMN_PREGNANCY_ID = "PREGNANCY_ID";
    private static final String COLUMN_GENDER = "GENDER";
    private static final String COLUMN_NAME = "NAME";

    @Override
    public void create(Pregnancy pregnancy) {
        Query.insertInto("PREGNANCY").columns(QueryColumn.column(COLUMN_MOTHER_ID, pregnancy.getMotherId()), QueryColumn.column(COLUMN_FATHER_ID, pregnancy.getFatherId()), QueryColumn.column(COLUMN_PREGNANCY_TIME, pregnancy.getPregnancyTime()), QueryColumn.column(COLUMN_ESTIMATED_DUE_DATE, pregnancy.getEstimatedDueDate()), QueryColumn.column(COLUMN_ACTUAL_DUE_DATE, pregnancy.getActualDueDate()), QueryColumn.column(COLUMN_MISCARRIAGE_DATE, pregnancy.getMiscarriageDate()), QueryColumn.column(COLUMN_OWNER_ID, pregnancy.getOwnerId()), QueryColumn.column(COLUMN_STATUS, pregnancy.getStatus()), QueryColumn.column(COLUMN_STATUS_CHANGE_DATE, pregnancy.getStatusChangeDate())).executeGetGeneratedKey(pregnancy::setId);
        for (PregnancyHorse ph : pregnancy.getHorses()) {
            Query.insertInto("PREGNANCY_HORSE").columns(QueryColumn.column(COLUMN_PREGNANCY_ID, pregnancy.getId()), QueryColumn.column(COLUMN_GENDER, ph.getHorseGender()), QueryColumn.column(COLUMN_NAME, ph.getName())).executeGetGeneratedKey(ph::setId);
        }
    }

    @Override
    public List<Pregnancy> retrieveAll() {
        return Query.selectAllFrom("PREGNANCY").getList(this::getPregnancyFromResultRow);
    }

    private Pregnancy getPregnancyFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int motherId = row.getInt(COLUMN_MOTHER_ID);
        int fatherId = row.getInt(COLUMN_FATHER_ID);
        Date pregnancyTime = row.getDate(COLUMN_PREGNANCY_TIME);
        Date estimatedDueDate = row.getDate(COLUMN_ESTIMATED_DUE_DATE);
        Date actualDueDate = row.getNullableDate(COLUMN_ACTUAL_DUE_DATE);
        Date miscarriageDate = row.getNullableDate(COLUMN_MISCARRIAGE_DATE);
        int ownerId = row.getInt(COLUMN_OWNER_ID);
        PregnancyStatus status = row.getEnum(COLUMN_STATUS, PregnancyStatus.class);
        Date statusChangeDateDate = row.getDate(COLUMN_STATUS_CHANGE_DATE);
        List<PregnancyHorse> pregnancyHorses = this.retrieveAllHorsesForPregnancy(id);
        return new Pregnancy(id, motherId, fatherId, pregnancyTime, estimatedDueDate, actualDueDate, miscarriageDate, ownerId, status, statusChangeDateDate, pregnancyHorses);
    }

    private List<PregnancyHorse> retrieveAllHorsesForPregnancy(int pregnancyId) {
        return Query.selectAllFrom("PREGNANCY_HORSE").where(QueryColumn.column(COLUMN_PREGNANCY_ID, pregnancyId)).getList(this::getPregnancyHorseFromResultRow);
    }

    private PregnancyHorse getPregnancyHorseFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        HorseGender gender = row.getEnum(COLUMN_GENDER, HorseGender.class);
        String name = row.getNullableString(COLUMN_NAME);
        return new PregnancyHorse(id, gender, name);
    }

    @Override
    public void update(Pregnancy pregnancy) {
        Query.update("PREGNANCY").set(QueryColumn.column(COLUMN_STATUS, pregnancy.getStatus()), QueryColumn.column(COLUMN_STATUS_CHANGE_DATE, pregnancy.getStatusChangeDate())).where(QueryColumn.column(COLUMN_ID, pregnancy.getId())).execute();
    }

    public void updateNameForPregnancyHorse(int pregnancyHorseId, String name) {
        Query.update("PREGNANCY_HORSE").set(QueryColumn.column(COLUMN_NAME, name)).where(QueryColumn.column(COLUMN_ID, pregnancyHorseId));
    }
}

