/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyException;
import com.equestricraft.core.horse.pregnancy.PregnancyProcessService;
import com.equestricraft.core.horse.pregnancy.PregnancyRepository;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.horse.pregnancy.PregnancySettings;
import com.equestricraft.logging.Log;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;

public class PregnancyProcessServiceImpl
implements PregnancyProcessService {
    @Service
    private PregnancySession pregnancySession;
    @Service
    private PregnancyRepository pregnancyRepository;
    private final ReentrantLock pregnanciesProcessLock = new ReentrantLock();
    private static final Log log = Log.getLogger(PregnancyProcessServiceImpl.class.getName());

    @Override
    public void processPregnancies() {
        if (this.pregnanciesProcessLock.tryLock()) {
            try {
                this.completePregnancies();
                this.checkMiscarriages();
            }
            finally {
                this.pregnanciesProcessLock.unlock();
            }
        } else {
            log.warn("An attempt was made to process pregnancies when they were already getting processed");
        }
    }

    private void completePregnancies() {
        List<Pregnancy> duePregnancies = this.pregnancyRepository.findActivePregnanciesWithDueTimeBefore(new Date());
        for (Pregnancy pregnancy : duePregnancies) {
            try {
                if (this.shouldBeStillborn()) {
                    this.pregnancySession.stillbornPregnancy(pregnancy);
                    continue;
                }
                this.pregnancySession.completePregnancy(pregnancy);
            }
            catch (PregnancyException ex) {
                log.error(String.format("Error completing pregnancy %s", pregnancy.getId()), ex);
            }
        }
    }

    private boolean shouldBeStillborn() {
        return NumberUtils.testProbability(PregnancySettings.getStillbornPercentage());
    }

    private void checkMiscarriages() {
        List<Pregnancy> needMiscarried = this.pregnancyRepository.findActivePregnanciesWithMiscarryTimeBefore(new Date());
        for (Pregnancy pregnancy : needMiscarried) {
            this.pregnancySession.miscarryPregnancy(pregnancy);
        }
    }
}

