/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.base.repository.RepositoryUpdatePolicy;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyDatabase;
import com.equestricraft.core.horse.pregnancy.PregnancyHorse;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class PregnancyRepository
extends Repository<Pregnancy, Integer> {
    @Service
    private PregnancyDatabase pregnancyDatabase;

    @Override
    protected RepositoryDatasource<Pregnancy, Integer> getDatasource() {
        return this.pregnancyDatabase;
    }

    @Override
    protected RepositoryUpdatePolicy updatePolicy() {
        return RepositoryUpdatePolicy.UPDATE_NOT_ALLOWED;
    }

    @Override
    protected Function<Pregnancy, Object> getIndexFunction() {
        return p -> p.getHorses().stream().map(PregnancyHorse::getId).toList();
    }

    public Optional<Pregnancy> findMostRecentPregnancyByMotherId(int horseId) {
        RepositorySearchQuery<Pregnancy> query = this.createSearchQuery();
        query.filter(p -> p.getMotherId() == horseId);
        query.sortReverse(Comparator.comparing(Pregnancy::getPregnancyTime));
        return query.single();
    }

    public Optional<Pregnancy> findActivePregnancyByMotherId(int horseId) {
        return this.findSingleByPredicates(p -> p.getMotherId() == horseId, p -> p.getStatus().equals((Object)PregnancyStatus.PREGNANT));
    }

    public List<Pregnancy> findActivePregnanciesWithDueTimeBefore(Date time) {
        return this.findListByPredicates(p -> p.getStatus().equals((Object)PregnancyStatus.PREGNANT), p -> p.getActualDueDate() != null && p.getActualDueDate().before(time));
    }

    public List<Pregnancy> findActivePregnanciesWithMiscarryTimeBefore(Date time) {
        return this.findListByPredicates(p -> p.getStatus().equals((Object)PregnancyStatus.PREGNANT), p -> p.getMiscarriageDate() != null && p.getMiscarriageDate().before(time));
    }

    public List<Pregnancy> findPregnanciesByMotherAndStatus(int horseId, PregnancyStatus status) {
        return this.findListByPredicates(p -> p.getMotherId() == horseId, p -> p.getStatus().equals((Object)status));
    }

    public List<Pregnancy> findPregnanciesByOwnerAndStatus(int ownerId, PregnancyStatus status) {
        return this.findListByPredicates(p -> p.getOwnerId() == ownerId, p -> p.getStatus().equals((Object)status));
    }

    public Optional<Pregnancy> findPregnancyContainingHorseId(int horseId) {
        return this.findByIndexKeyIfExists(horseId);
    }

    public void updateNameForPregnancyHorse(PregnancyHorse pregnancyHorse, String name) {
        this.pregnancyDatabase.updateNameForPregnancyHorse(pregnancyHorse.getId(), name);
        pregnancyHorse.setName(name);
    }
}

