/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseGender;
import com.equestricraft.common.HorseOrigin;
import com.equestricraft.common.PregnancyStatus;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.create.HorseCreateException;
import com.equestricraft.core.horse.create.HorseCreateRequest;
import com.equestricraft.core.horse.create.HorseCreateSession;
import com.equestricraft.core.horse.name.HorseNameService;
import com.equestricraft.core.horse.pregnancy.Pregnancy;
import com.equestricraft.core.horse.pregnancy.PregnancyCompleteEvent;
import com.equestricraft.core.horse.pregnancy.PregnancyException;
import com.equestricraft.core.horse.pregnancy.PregnancyHorse;
import com.equestricraft.core.horse.pregnancy.PregnancyInfo;
import com.equestricraft.core.horse.pregnancy.PregnancyRepository;
import com.equestricraft.core.horse.pregnancy.PregnancyRequest;
import com.equestricraft.core.horse.pregnancy.PregnancySession;
import com.equestricraft.core.horse.pregnancy.PregnancySettings;
import com.equestricraft.core.horse.pregnancy.UltrasoundInfo;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.logging.Log;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;

public class PregnancySessionImpl
implements PregnancySession {
    @Service
    private PregnancyRepository pregnancyRepository;
    @Service
    private HorseCreateSession horseCreateSession;
    @Service
    private HorseRepository horseRepository;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private HorseNameService horseNameService;
    private static final Log log = Log.getLogger(PregnancySessionImpl.class.getName());

    @Override
    public void addNewPregnancy(PregnancyRequest pregnancyRequest) throws PregnancyException {
        EQHorse stallion = (EQHorse)this.horseRepository.findByKey(pregnancyRequest.fatherId());
        EQHorse mare = (EQHorse)this.horseRepository.findByKey(pregnancyRequest.motherId());
        if (stallion.getAge().getMonths() < PregnancySettings.getMinimumBreedingAgeMonthsStallion()) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.too-young"));
        }
        if (mare.getAge().getMonths() < PregnancySettings.getMinimumBreedingAgeMonthsMare()) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.too-young"));
        }
        if (!this.checkFertility(stallion)) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.fertility-check-failed"));
        }
        if (!this.checkFertility(mare)) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.fertility-check-failed"));
        }
        if (!mare.getBreeding().isInHeat()) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.mare-not-in-heat"));
        }
        if (mare.getPregnancy().isPregnant()) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.already-pregnant"));
        }
        Date estimatedDueDate = this.getEstimatedDate();
        Date actualDueDate = null;
        Date miscarryDate = null;
        if (this.shouldMiscarry()) {
            miscarryDate = this.getMiscarriageDate();
        } else {
            actualDueDate = this.getActualDate();
        }
        int foalsCount = this.getCountToHave();
        List<PregnancyHorse> pregnancyHorses = this.generateHorses(pregnancyRequest.owner(), foalsCount);
        Date now = new Date();
        Pregnancy pregnancy = new Pregnancy(0, pregnancyRequest.motherId(), pregnancyRequest.fatherId(), now, estimatedDueDate, actualDueDate, miscarryDate, pregnancyRequest.owner().getId(), PregnancyStatus.PREGNANT, now, pregnancyHorses);
        this.pregnancyRepository.add(pregnancy);
    }

    private boolean checkFertility(EQHorse horse) {
        return NumberUtils.randomFloatInRange(0.0f, 1.0f) < horse.getFertility().getValue();
    }

    private Date getEstimatedDate() {
        return this.getRandomDateFromSettings(PregnancySettings.getEstimatedDurationMinimumHours(), PregnancySettings.getEstimatedDurationMaximumHours());
    }

    private boolean shouldMiscarry() {
        return NumberUtils.testProbability(PregnancySettings.getMiscarriagePercentage());
    }

    private Date getMiscarriageDate() {
        return this.getRandomDateFromSettings(PregnancySettings.getMiscarriageMinimumHours(), PregnancySettings.getMiscarriageMaximumHours());
    }

    private Date getActualDate() {
        return this.getRandomDateFromSettings(PregnancySettings.getActualDurationMinimumHours(), PregnancySettings.getActualDurationMaximumHours());
    }

    private Date getRandomDateFromSettings(int minimum, int maximum) {
        int hours = NumberUtils.randomIntInRange(minimum, maximum);
        return DateUtils.futureHoursOffset(hours);
    }

    private List<PregnancyHorse> generateHorses(ECPlayer player, int count) {
        ArrayList<PregnancyHorse> pregnancyHorses = new ArrayList<PregnancyHorse>(count);
        for (int i = 0; i < count; ++i) {
            HorseGender gender = HorseGender.getRandomGender();
            PregnancyHorse ph = new PregnancyHorse(0, gender, player.getIgn() + count);
            pregnancyHorses.add(ph);
        }
        return pregnancyHorses;
    }

    private int getCountToHave() {
        return this.shouldBeTwins() ? 2 : 1;
    }

    private boolean shouldBeTwins() {
        return NumberUtils.testProbability(PregnancySettings.getTwinsPercentage().floatValue());
    }

    @Override
    public Optional<UltrasoundInfo> getUltrasound(EQHorse horse) {
        return this.pregnancyRepository.findMostRecentPregnancyByMotherId(horse.getId()).map(this::generateUltrasoundForPregnancy);
    }

    private UltrasoundInfo generateUltrasoundForPregnancy(Pregnancy pregnancy) {
        if (!this.isPregnancyActive(pregnancy)) {
            return null;
        }
        EQHorse mother = this.getMotherForPregnancy(pregnancy);
        EQHorse father = this.getFatherForPregnancy(pregnancy);
        Date estimatedDueDate = pregnancy.getEstimatedDueDate();
        List<UltrasoundInfo.UltrasoundHorseInfo> horses = this.getHorsesForPregnancy(pregnancy);
        if (pregnancy.getStatus() == PregnancyStatus.MISCARRIED) {
            return UltrasoundInfo.miscarried(pregnancy.getId(), mother, father, pregnancy.getPregnancyTime(), estimatedDueDate, horses);
        }
        return UltrasoundInfo.pregnant(pregnancy.getId(), mother, father, pregnancy.getPregnancyTime(), estimatedDueDate, horses);
    }

    private boolean isPregnancyActive(Pregnancy pregnancy) {
        return pregnancy.getStatus() == PregnancyStatus.PREGNANT || pregnancy.getStatus() == PregnancyStatus.MISCARRIED;
    }

    private EQHorse getMotherForPregnancy(Pregnancy pregnancy) {
        EQHorse mother = (EQHorse)this.horseRepository.findByKey(pregnancy.getMotherId());
        if (mother.getHorseGender() != HorseGender.MARE) {
            log.warn("Horse {} is the mother of an unborn foal, yet is not a mare...", (Object)mother.getId());
        }
        return mother;
    }

    private EQHorse getFatherForPregnancy(Pregnancy pregnancy) {
        EQHorse father = (EQHorse)this.horseRepository.findByKey(pregnancy.getFatherId());
        if (father.getHorseGender() == HorseGender.MARE) {
            log.warn("Horse {} is the father of an unborn foal, yet is a mare...", (Object)father.getId());
        }
        return father;
    }

    private List<UltrasoundInfo.UltrasoundHorseInfo> getHorsesForPregnancy(Pregnancy pregnancy) {
        int accuracy = this.calculateGenderAccuracyForPregnancy(pregnancy);
        return pregnancy.getHorses().stream().map(ph -> {
            HorseGender gender = this.estimateGender(ph.getHorseGender(), accuracy);
            return new UltrasoundInfo.UltrasoundHorseInfo(ph.getId(), gender, ph.getName());
        }).toList();
    }

    private int calculateGenderAccuracyForPregnancy(Pregnancy pregnancy) {
        int startingPercentage = PregnancySettings.getGenderStartingAccuracy();
        int maximumPercentage = PregnancySettings.getGenderMaximumAccuracy();
        int maxAccuracyHours = PregnancySettings.getGenderMaxAccuracyHours();
        int hoursPregnant = DateUtils.hoursSince(pregnancy.getPregnancyTime());
        if (hoursPregnant <= 0) {
            return startingPercentage;
        }
        if (hoursPregnant > maxAccuracyHours) {
            return maximumPercentage;
        }
        int totalScaleSize = maximumPercentage - startingPercentage;
        float percentageThroughAccuracyTime = (float)((double)hoursPregnant / (double)maxAccuracyHours);
        int additionalPercentage = (int)((float)totalScaleSize * percentageThroughAccuracyTime);
        return startingPercentage + additionalPercentage;
    }

    private HorseGender estimateGender(HorseGender actualGender, int accuracy) {
        if (NumberUtils.testProbability(accuracy)) {
            return actualGender;
        }
        return actualGender.opposite();
    }

    @Override
    public boolean isHorseCurrentlyPregnant(EQHorse horse) {
        Optional<Pregnancy> pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horse.getId());
        return pregnancy.map(p -> p.getStatus().equals((Object)PregnancyStatus.PREGNANT)).orElse(false);
    }

    @Override
    public void abortPregnancyForHorse(int horseId) throws PregnancyException {
        Pregnancy pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horseId).orElseThrow(() -> new PregnancyException(I18n.getLabel("horse.pregnancy.not-pregnant")));
        this.abortPregnancy(pregnancy);
    }

    private void abortPregnancy(Pregnancy pregnancy) {
        pregnancy.setStatus(PregnancyStatus.ABORTED);
        pregnancy.setStatusChangeDate(new Date());
        pregnancy.save();
        this.clearHorsesPregnancyAwareTime(pregnancy.getMotherId());
    }

    @Override
    public void miscarryPregnancyForHorse(int horseId) throws PregnancyException {
        Pregnancy pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horseId).orElseThrow(() -> new PregnancyException(I18n.getLabel("horse.pregnancy.not-pregnant")));
        this.miscarryPregnancy(pregnancy);
    }

    @Override
    public void miscarryPregnancy(Pregnancy pregnancy) {
        pregnancy.setStatus(PregnancyStatus.MISCARRIED);
        pregnancy.setStatusChangeDate(new Date());
        pregnancy.save();
        this.clearHorsesPregnancyAwareTime(pregnancy.getMotherId());
    }

    @Override
    public void stillbornPregnancyForHorse(int horseId) throws PregnancyException {
        Pregnancy pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horseId).orElseThrow(() -> new PregnancyException(I18n.getLabel("horse.pregnancy.not-pregnant")));
        this.stillbornPregnancy(pregnancy);
    }

    @Override
    public void stillbornPregnancy(Pregnancy pregnancy) {
        pregnancy.setStatus(PregnancyStatus.STILLBORN);
        pregnancy.setStatusChangeDate(new Date());
        pregnancy.save();
        this.clearHorsesPregnancyAwareTime(pregnancy.getMotherId());
    }

    @Override
    public void completePregnancyForHorse(int horseId) throws PregnancyException {
        Pregnancy pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horseId).orElseThrow(() -> new PregnancyException(I18n.getLabel("horse.pregnancy.not-pregnant")));
        this.completePregnancy(pregnancy);
    }

    @Override
    public void completePregnancy(Pregnancy pregnancy) throws PregnancyException {
        if (!pregnancy.getStatus().equals((Object)PregnancyStatus.PREGNANT)) {
            throw new PregnancyException(I18n.getLabel("horse.pregnancy.already-completed"));
        }
        CorePlayer owner = (CorePlayer)this.playerRepository.findByKey(pregnancy.getOwnerId());
        for (PregnancyHorse pregnancyHorse : pregnancy.getHorses()) {
            String name = this.getNameForHorse(owner, pregnancyHorse);
            HorseCreateRequest request = HorseCreateRequest.Builder.start().withOrigin(HorseOrigin.BREEDING).withName(name).withOwner(owner).withGender(pregnancyHorse.getHorseGender()).withAgeMonths(0).withParents(pregnancy.getMotherId(), pregnancy.getFatherId()).withBypassHorseLimit(true).withAllowDuplicateName(true).complete();
            try {
                EQHorse foal = this.horseCreateSession.createHorse(request);
                EQHorse mother = (EQHorse)this.horseRepository.findByKey(pregnancy.getMotherId());
                foal.setDirectionalCoordinate(mother.getDirectionalCoordinate());
                this.setPregnancyConceived(pregnancy);
                PregnancyCompleteEvent event = new PregnancyCompleteEvent(mother, foal);
                ECEventBus.post(event);
            }
            catch (HorseCreateException ex) {
                log.error("Error creating horse from pregnancy ID {}", (Object)pregnancy.getId());
                throw new PregnancyException(ex);
            }
        }
        this.clearHorsesPregnancyAwareTime(pregnancy.getMotherId());
    }

    private String getNameForHorse(ECPlayer owner, PregnancyHorse pregnancyHorse) {
        String name = pregnancyHorse.getName();
        if (name == null) {
            name = this.horseNameService.generateAutoIncrementingNameForPlayer(owner);
        } else {
            String nameToCheck = name;
            int nextNumberToAdd = 1;
            while (owner.getHorses().isUsingName(nameToCheck)) {
                nameToCheck = name;
                nameToCheck = String.format("%s%s", nameToCheck, nextNumberToAdd++);
            }
            name = nameToCheck;
        }
        return name.replaceAll("[^a-zA-Z0-9]", "");
    }

    private void setPregnancyConceived(Pregnancy pregnancy) {
        pregnancy.setStatus(PregnancyStatus.CONCEIVED);
        pregnancy.setStatusChangeDate(new Date());
        pregnancy.save();
    }

    private void clearHorsesPregnancyAwareTime(int horseId) {
        EQHorse horse = (EQHorse)this.horseRepository.findByKey(horseId);
        horse.setPregnancyAwareTime(null);
        horse.save();
    }

    @Override
    public List<Pregnancy> retrievePregnanciesForHorseWithStatusInPastDuration(int horseId, PregnancyStatus status, Duration duration) {
        List<Pregnancy> pregnancies = this.pregnancyRepository.findPregnanciesByMotherAndStatus(horseId, status);
        return pregnancies.stream().filter(p -> DateUtils.millisSince(p.getStatusChangeDate()) <= duration.toMillis()).toList();
    }

    @Override
    public Optional<Duration> retrieveDurationHorseHasBeenPregnantFor(EQHorse horse) {
        Optional<Pregnancy> pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horse.getId());
        return pregnancy.map(p -> {
            long millisSincePregnant = DateUtils.millisSince(p.getPregnancyTime());
            return Duration.ofMillis(millisSincePregnant);
        });
    }

    @Override
    public Optional<PregnancyInfo> retrievePregnancyInfoForHorse(int horseId) {
        Optional<Pregnancy> pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horseId);
        return pregnancy.map(p -> {
            CorePlayer player = (CorePlayer)this.playerRepository.findByKey(p.getOwnerId());
            Date actualDueDate = p.getActualDueDate();
            return new PregnancyInfo(player, actualDueDate);
        });
    }

    @Override
    public Optional<Double> calculatePercentageThroughPregnancy(EQHorse horse) {
        Optional<Pregnancy> pregnancy = this.pregnancyRepository.findActivePregnancyByMotherId(horse.getId());
        if (pregnancy.isPresent()) {
            Date startTime = pregnancy.get().getPregnancyTime();
            Date endTime = pregnancy.get().getActualDueDate();
            Date now = new Date();
            long totalDuration = endTime.getTime() - startTime.getTime();
            long durationPassed = now.getTime() - startTime.getTime();
            return Optional.of((double)durationPassed / (double)totalDuration * 100.0);
        }
        return Optional.empty();
    }

    @Override
    public int getUnbornFoalCountForPlayer(ECPlayer player) {
        int total = 0;
        List<Pregnancy> pregnancies = this.pregnancyRepository.findPregnanciesByOwnerAndStatus(player.getId(), PregnancyStatus.PREGNANT);
        for (Pregnancy pregnancy : pregnancies) {
            total += pregnancy.getHorses().size();
        }
        return total;
    }
}

