/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.pregnancy;

import com.equestricraft.settings.Setting;
import com.equestricraft.settings.SettingDescription;
import com.equestricraft.settings.SettingName;

public class PregnancySettings {
    @Setting(value="pregnancy.twins-percentage")
    @SettingName(value="Pregnancy - Twins Percentage")
    @SettingDescription(value="The percentage probability of a horse being pregnant with twins")
    private static Float twinsPercentage = Float.valueOf(0.1f);
    @Setting(value="pregnancy.stillborn-percentage")
    @SettingName(value="Pregnancy - Stillborn Percentage")
    @SettingDescription(value="The percentage probability of a horse being a stillborn")
    private static Integer stillbornPercentage = 30;
    @Setting(value="pregnancy.miscarriage-maximum-hours")
    @SettingName(value="Pregnancy - Maximum Miscarriage Hours")
    @SettingDescription(value="The latest time a miscarriage can happen")
    private static Integer miscarriageMaximumHours = 12;
    @Setting(value="pregnancy.miscarriage-minimum-hours")
    @SettingName(value="Pregnancy - Minimum Miscarriage Hours")
    @SettingDescription(value="The earliest time a miscarriage can happen")
    private static Integer miscarriageMinimumHours = 0;
    @Setting(value="pregnancy.miscarriage-percentage")
    @SettingName(value="Pregnancy - Miscarriage Percentage")
    @SettingDescription(value="The percentage probability of a miscarriage")
    private static Integer miscarriagePercentage = 30;
    @Setting(value="pregnancy.gender-maximum-accuracy")
    @SettingName(value="Pregnancy - Maximum Gender Accuracy")
    @SettingDescription(value="The maximum accuracy percentage for genders")
    private static Integer genderMaximumAccuracy = 99;
    @Setting(value="pregnancy.gender-starting-accuracy")
    @SettingName(value="Pregnancy - Gender Starting Accuracy")
    @SettingDescription(value="The starting accuracy percentage for genders")
    private static Integer genderStartingAccuracy = 50;
    @Setting(value="pregnancy.gender-max-accuracy-hours")
    @SettingName(value="Pregnancy - Maximum Gender Accuracy Hours")
    @SettingDescription(value="The duration of time until the gender accuracy will be maximum")
    private static Integer genderMaxAccuracyHours = 2;
    @Setting(value="pregnancy.actual-duration.maximum-hours")
    @SettingName(value="Pregnancy - Actual Maximum Duration hours")
    @SettingDescription(value="The maximum amount of time a pregnancy should take")
    private static Integer actualDurationMaximumHours = 25;
    @Setting(value="pregnancy.actual-duration.minimum-hours")
    @SettingName(value="Pregnancy - Actual Minimum Duration Hours")
    @SettingDescription(value="The minimum amount of time a pregnancy should take")
    private static Integer actualDurationMinimumHours = 10;
    @Setting(value="pregnancy.estimated-duration.maximum-hours")
    @SettingName(value="Pregnancy - Estimated Duration Maximum Hours")
    @SettingDescription(value="The maximum duration for a pregnancy estimation")
    private static Integer estimatedDurationMaximumHours = 20;
    @Setting(value="pregnancy.estimated-duration.minimum-hours")
    @SettingName(value="Pregnancy - Estimated Duration Minimum Hours")
    @SettingDescription(value="The minimum duration for a pregnancy estimation")
    private static Integer estimatedDurationMinimumHours = 10;
    @Setting(value="pregnancy.heat.cycle-duration.days")
    @SettingName(value="Pregnancy - Mare Heat Cycle Duration Days")
    @SettingDescription(value="The duration in days a heat cycle lasts for a mare")
    private static Integer mareHeatCycleDurationDays = 21;
    @Setting(value="pregnancy.heat.duration-days")
    @SettingName(value="Pregnancy - Mare Heat Duration Days")
    @SettingDescription(value="The duration in days a mare is in heat for within a cycle")
    private static Integer mareHeatDurationDays = 8;
    @Setting(value="pregnancy.minimum-breeding-age.stallion")
    @SettingName(value="Pregnancy - Stallion Minimum Breeding Age")
    @SettingDescription(value="The minimum age in months for a stallion to breed")
    private static Integer minimumBreedingAgeMonthsStallion = 48;
    @Setting(value="pregnancy.minimum-breeding-age.mare")
    @SettingName(value="Pregnancy - Mare Minimum Breeding Age")
    @SettingDescription(value="The minimum age in months for a mare to breed")
    private static Integer minimumBreedingAgeMonthsMare = 48;
    @Setting(value="pregnancy.stallion-find-mate.probability-per-tick")
    @SettingName(value="Pregnancy - Stallion Find Mate Probability Per Tick")
    @SettingDescription(value="The probability of a stallion deciding to find a mate on each tick")
    private static Float stallionFindMateProbabilityPerTick = Float.valueOf(0.001f);
    @Setting(value="pregnancy.mare-accept-mate.intelligence-threshold")
    @SettingName(value="Pregnancy - Mare Accept Mate Intelligence Threshold")
    @SettingDescription(value="The value at which a mare is considered intelligent when it comes to breeding")
    private static Float mareAcceptMateIntelligenceThreshold = Float.valueOf(0.5f);
    @Setting(value="pregnancy.mare-accept-mate.maximum-memory-days")
    @SettingName(value="Pregnancy - Mare Accept Mate Maximum Memory Days")
    @SettingDescription(value="The maximum amount of days breeding attempts will be remembered for")
    private static Integer mareAcceptMateMaximumMemoryDays = 30;

    public static Float getTwinsPercentage() {
        return twinsPercentage;
    }

    public static Integer getStillbornPercentage() {
        return stillbornPercentage;
    }

    public static Integer getMiscarriageMaximumHours() {
        return miscarriageMaximumHours;
    }

    public static Integer getMiscarriageMinimumHours() {
        return miscarriageMinimumHours;
    }

    public static Integer getMiscarriagePercentage() {
        return miscarriagePercentage;
    }

    public static Integer getGenderMaximumAccuracy() {
        return genderMaximumAccuracy;
    }

    public static Integer getGenderStartingAccuracy() {
        return genderStartingAccuracy;
    }

    public static Integer getGenderMaxAccuracyHours() {
        return genderMaxAccuracyHours;
    }

    public static Integer getActualDurationMaximumHours() {
        return actualDurationMaximumHours;
    }

    public static Integer getActualDurationMinimumHours() {
        return actualDurationMinimumHours;
    }

    public static Integer getEstimatedDurationMaximumHours() {
        return estimatedDurationMaximumHours;
    }

    public static Integer getEstimatedDurationMinimumHours() {
        return estimatedDurationMinimumHours;
    }

    public static Integer getMareHeatCycleDurationDays() {
        return mareHeatCycleDurationDays;
    }

    public static Integer getMareHeatDurationDays() {
        return mareHeatDurationDays;
    }

    public static Integer getMinimumBreedingAgeMonthsStallion() {
        return minimumBreedingAgeMonthsStallion;
    }

    public static Integer getMinimumBreedingAgeMonthsMare() {
        return minimumBreedingAgeMonthsMare;
    }

    public static Float getStallionFindMateProbabilityPerTick() {
        return stallionFindMateProbabilityPerTick;
    }

    public static Float getMareAcceptMateIntelligenceThreshold() {
        return mareAcceptMateIntelligenceThreshold;
    }

    public static Integer getMareAcceptMateMaximumMemoryDays() {
        return mareAcceptMateMaximumMemoryDays;
    }

    private PregnancySettings() {
    }
}

