/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.prescription;

import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.prescription.Prescription;
import com.equestricraft.core.horse.prescription.PrescriptionInfo;
import com.equestricraft.core.horse.prescription.PrescriptionRequest;
import com.equestricraft.core.horse.prescription.PrescriptionSession;
import java.util.List;

public class HorsePrescriptionAccessor
extends AbstractHorseAccessor {
    @Service
    private static PrescriptionSession prescriptionSession;

    public HorsePrescriptionAccessor(EQHorse horse) {
        super(horse);
    }

    public Prescription givePrescription(PrescriptionRequest prescriptionRequest) {
        return prescriptionSession.processPrescriptionRequest(prescriptionRequest);
    }

    public int getCurrentMaximumPrescribedDosageForMedicine(int medicineId) {
        return prescriptionSession.getHorsesCurrentMaximumPrescribedDosageForMedicine(this.horse.getId(), medicineId);
    }

    public List<PrescriptionInfo> getPrescriptions() {
        return prescriptionSession.getPrescriptionInformationForHorse(this.horse.getId());
    }
}

