/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.prescription;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.prescription.Prescription;
import com.equestricraft.core.horse.prescription.PrescriptionMedicine;
import java.util.List;

public class PrescriptionDatabase
implements RepositoryDatasource<Prescription, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_PRESCRIPTION_ID = "PRESCRIPTION_ID";
    private static final String COLUMN_MEDICINE_ID = "MEDICINE_ID";
    private static final String COLUMN_DOSAGE_AMOUNT = "DOSAGE_AMOUNT";
    private static final String COLUMN_MAXIMUM_OVER_DOSE = "MAXIMUM_OVER_DOSE";
    private static final String COLUMN_DURATION_HOURS = "DURATION_HOURS";

    @Override
    public void create(Prescription prescription) {
        Query.insertInto("PRESCRIPTION").columns(QueryColumn.column(COLUMN_HORSE_ID, prescription.getHorseId()), QueryColumn.column(COLUMN_DESCRIPTION, prescription.getDescription()), QueryColumn.column(COLUMN_TIME_STAMP, prescription.getTimeStamp())).executeGetGeneratedKey(prescription::setId);
        for (PrescriptionMedicine medicine : prescription.getPrescriptionMedicines()) {
            Query.insertInto("PRESCRIPTION_MEDICINE").columns(QueryColumn.column(COLUMN_PRESCRIPTION_ID, prescription.getId()), QueryColumn.column(COLUMN_MEDICINE_ID, medicine.getMedicineId()), QueryColumn.column(COLUMN_DOSAGE_AMOUNT, medicine.getDosageAmount()), QueryColumn.column(COLUMN_MAXIMUM_OVER_DOSE, medicine.getMaximumOverDose()), QueryColumn.column(COLUMN_DURATION_HOURS, medicine.getDurationHours())).execute();
        }
    }

    @Override
    public List<Prescription> retrieveAll() {
        return Query.selectAllFrom("PRESCRIPTION").getList(this::getPrescriptionFromResultRow);
    }

    private Prescription getPrescriptionFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        String description = row.getString(COLUMN_DESCRIPTION);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        List<PrescriptionMedicine> prescriptionMedicines = this.getMedicinesForPrescription(id);
        return new Prescription(id, horseId, description, timeStamp, prescriptionMedicines);
    }

    private List<PrescriptionMedicine> getMedicinesForPrescription(int prescriptionId) {
        return Query.selectAllFrom("PRESCRIPTION_MEDICINE").where(QueryColumn.column(COLUMN_PRESCRIPTION_ID, prescriptionId)).getList(this::getPrescriptionMedicineFromResultRow);
    }

    private PrescriptionMedicine getPrescriptionMedicineFromResultRow(ResultRow row) {
        int medicineId = row.getInt(COLUMN_MEDICINE_ID);
        int dosageAmount = row.getInt(COLUMN_DOSAGE_AMOUNT);
        int maximumOverDose = row.getInt(COLUMN_MAXIMUM_OVER_DOSE);
        int durationHours = row.getInt(COLUMN_DURATION_HOURS);
        return new PrescriptionMedicine(medicineId, dosageAmount, maximumOverDose, durationHours);
    }
}

