/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.prescription;

import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.medicine.Medicine;
import java.util.LinkedList;
import java.util.List;

public class PrescriptionRequest {
    private final EQHorse horse;
    private final String description;
    private final List<PrescriptionRequestMedicine> prescriptionRequestMedicines;

    private PrescriptionRequest(EQHorse horse, String description, List<PrescriptionRequestMedicine> prescriptionRequestMedicines) {
        this.horse = horse;
        this.description = description;
        this.prescriptionRequestMedicines = prescriptionRequestMedicines;
    }

    public EQHorse getHorse() {
        return this.horse;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PrescriptionRequestMedicine> getPrescriptionRequestMedicines() {
        return this.prescriptionRequestMedicines;
    }

    public static Builder start(EQHorse horse) {
        return new Builder(horse);
    }

    public static class Builder {
        private final EQHorse horse;
        private String description = null;
        private final List<PrescriptionRequestMedicine> medicines = new LinkedList<PrescriptionRequestMedicine>();

        private Builder(EQHorse horse) {
            this.horse = horse;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withMedicine(Medicine medicine, int dosageSize, int maximumOverDose, int durationHours) {
            this.medicines.add(new PrescriptionRequestMedicine(medicine, dosageSize, maximumOverDose, durationHours));
            return this;
        }

        public PrescriptionRequest complete() {
            return new PrescriptionRequest(this.horse, this.description, this.medicines);
        }
    }

    record PrescriptionRequestMedicine(Medicine medicine, int dosageSize, int maximumOverDose, int durationHours) {
    }
}

