/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.prescription;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.horse.prescription.Prescription;
import com.equestricraft.core.horse.prescription.PrescriptionInfo;
import com.equestricraft.core.horse.prescription.PrescriptionMedicine;
import com.equestricraft.core.horse.prescription.PrescriptionRepository;
import com.equestricraft.core.horse.prescription.PrescriptionRequest;
import com.equestricraft.core.horse.prescription.PrescriptionSession;
import com.equestricraft.core.medicine.Medicine;
import java.util.Date;
import java.util.List;

public class PrescriptionSessionImpl
implements PrescriptionSession {
    @Service
    private PrescriptionRepository prescriptionRepository;

    @Override
    public Prescription processPrescriptionRequest(PrescriptionRequest prescriptionRequest) {
        Prescription newPrescription = this.buildPrescription(prescriptionRequest);
        return this.prescriptionRepository.add(newPrescription);
    }

    private Prescription buildPrescription(PrescriptionRequest prescriptionRequest) {
        List<PrescriptionMedicine> medicines = prescriptionRequest.getPrescriptionRequestMedicines().stream().map(this::buildPrescriptionMedicine).toList();
        return new Prescription(0, prescriptionRequest.getHorse().getId(), prescriptionRequest.getDescription(), System.currentTimeMillis(), medicines);
    }

    private PrescriptionMedicine buildPrescriptionMedicine(PrescriptionRequest.PrescriptionRequestMedicine rm) {
        return new PrescriptionMedicine(rm.medicine().getId(), rm.dosageSize(), rm.maximumOverDose(), rm.durationHours());
    }

    @Override
    public int getHorsesCurrentMaximumPrescribedDosageForMedicine(int horseId, int medicineId) {
        List<Prescription> prescriptions = this.prescriptionRepository.findPrescriptionsByHorse(horseId);
        int max = 0;
        for (Prescription p : prescriptions) {
            for (PrescriptionMedicine m : p.getPrescriptionMedicines()) {
                Date endTime;
                if (m.getMedicineId() != medicineId || DateUtils.isInPast(endTime = DateUtils.futureHoursOffset(new Date(p.getTimeStamp()), m.getDurationHours())) || m.getDosageAmount() <= max) continue;
                max = m.getDosageAmount();
            }
        }
        return max;
    }

    @Override
    public List<PrescriptionInfo> getPrescriptionInformationForHorse(int horseId) {
        List<Prescription> prescriptions = this.prescriptionRepository.findPrescriptionsByHorse(horseId);
        return prescriptions.stream().filter(this::isPrescriptionStillActive).map(this::buildInfo).toList();
    }

    private PrescriptionInfo buildInfo(Prescription p) {
        List<PrescriptionInfo.PrescriptionMedicine> medicineInfo = p.getPrescriptionMedicines().stream().map(m -> {
            Medicine medicine = m.getMedicine();
            return new PrescriptionInfo.PrescriptionMedicine(medicine.getId(), medicine.getName(), m.getDosageAmount(), medicine.getDosageUnitName(), m.getDurationHours());
        }).toList();
        return new PrescriptionInfo(p.getId(), p.getDescription(), DateUtils.daysSince(p.getTimeStamp()), medicineInfo);
    }

    private boolean isPrescriptionStillActive(Prescription prescription) {
        int hoursSince = DateUtils.hoursSince(prescription.getTimeStamp());
        return prescription.getPrescriptionMedicines().stream().allMatch(m -> m.getDurationHours() > hoursSince);
    }
}

