/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.provision.HorseProvisionStatus;

public enum HorseFullnessStatus implements HorseProvisionStatus
{
    OVERFED("horse.hunger-status.overfed.label"),
    OPTIMAL("horse.hunger-status.optimal.label"),
    VERY_GOOD("horse.hunger-status.very-good.label"),
    GOOD("horse.hunger-status.good.label"),
    OK("horse.hunger-status.ok.label"),
    UNDERFED("horse.hunger-status.underfed.label"),
    SERIOUSLY_UNDERFED("horse.hunger-status.seriously-underfed.label");

    private final String key;

    private HorseFullnessStatus(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getTranslatedName() {
        return I18n.getLabel(this.getKey());
    }

    @Override
    public boolean isRed() {
        return this == UNDERFED || this == SERIOUSLY_UNDERFED;
    }

    @Override
    public boolean isAmber() {
        return this == OVERFED || this == GOOD || this == OK;
    }

    @Override
    public boolean isGreen() {
        return this == OPTIMAL || this == VERY_GOOD;
    }

    public static HorseFullnessStatus getStatusFromPercentage(double percentage) {
        if (percentage >= 120.0) {
            return OVERFED;
        }
        if (percentage >= 90.0) {
            return OPTIMAL;
        }
        if (percentage >= 80.0) {
            return VERY_GOOD;
        }
        if (percentage >= 65.0) {
            return GOOD;
        }
        if (percentage >= 50.0) {
            return OK;
        }
        if (percentage >= 30.0) {
            return UNDERFED;
        }
        return SERIOUSLY_UNDERFED;
    }
}

