/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision;

import com.equestricraft.common.i18n.I18n;
import com.equestricraft.core.horse.provision.HorseProvisionStatus;

public enum HorseHydrationStatus implements HorseProvisionStatus
{
    OVER_HYDRATED("horse.thirst-status.over-hydrated.label"),
    OPTIMAL("horse.thirst-status.optimal.label"),
    VERY_GOOD("horse.thirst-status.very-good.label"),
    GOOD("horse.thirst-status.good.label"),
    OK("horse.thirst-status.ok.label"),
    DEHYDRATED("horse.thirst-status.dehydrated.label"),
    SERIOUSLY_DEHYDRATED("horse.thirst-status.seriously-dehydrated.label");

    private final String key;

    private HorseHydrationStatus(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getTranslatedName() {
        return I18n.getLabel(this.getKey());
    }

    @Override
    public boolean isRed() {
        return this == DEHYDRATED || this == SERIOUSLY_DEHYDRATED;
    }

    @Override
    public boolean isAmber() {
        return this == OVER_HYDRATED || this == GOOD || this == OK;
    }

    @Override
    public boolean isGreen() {
        return this == OPTIMAL || this == VERY_GOOD;
    }

    public static HorseHydrationStatus getStatusFromPercentage(double percentage) {
        if (percentage >= 120.0) {
            return OVER_HYDRATED;
        }
        if (percentage >= 90.0) {
            return OPTIMAL;
        }
        if (percentage >= 80.0) {
            return VERY_GOOD;
        }
        if (percentage >= 65.0) {
            return GOOD;
        }
        if (percentage >= 50.0) {
            return OK;
        }
        if (percentage >= 30.0) {
            return DEHYDRATED;
        }
        return SERIOUSLY_DEHYDRATED;
    }
}

