/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.CachedValue;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.horse.AbstractHorseAccessor;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.provision.HorseFullnessStatus;
import com.equestricraft.core.horse.provision.HorseHydrationStatus;
import com.equestricraft.core.horse.provision.HorseProvisionGiveSession;
import com.equestricraft.core.horse.provision.HorseProvisionSession;
import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.core.horse.provision.ProvisionGiveException;
import com.equestricraft.core.player.ECPlayer;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;

public class HorseProvisionAccessor
extends AbstractHorseAccessor {
    @Service
    private static HorseProvisionSession horseProvisionSession;
    @Service
    private static HorseProvisionGiveSession horseProvisionGiveSession;
    private final CachedValue<Double> fullnessValue = new CachedValue<Double>(this::getUpdatedFullnessValue, Duration.ofMinutes(2L));
    private final CachedValue<Double> hydrationValue = new CachedValue<Double>(this::getUpdatedHydrationValue, Duration.ofMinutes(2L));

    public HorseProvisionAccessor(EQHorse horse) {
        super(horse);
    }

    public HorseFullnessStatus getFullnessState() {
        double percentage = this.getFullnessPercentage();
        return HorseFullnessStatus.getStatusFromPercentage(percentage);
    }

    public double getFullnessPercentage() {
        return this.fullnessValue.get();
    }

    public float getFullness() {
        return (float)(this.getFullnessPercentage() / 100.0);
    }

    public HorseHydrationStatus getHydrationState() {
        double percentage = this.getHydrationPercentage();
        return HorseHydrationStatus.getStatusFromPercentage(percentage);
    }

    public double getHydrationPercentage() {
        return this.hydrationValue.get();
    }

    public float getHydration() {
        return (float)(this.getHydrationPercentage() / 100.0);
    }

    public double getGramsOfFoodConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfFoodConsumedInPastDuration(this.horse.getId(), duration);
    }

    public double getGramsOfExpiredFoodConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfExpiredFoodConsumedInPastDuration(this.horse.getId(), duration);
    }

    public double getGramsOfSpoiledFoodConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfSpoiledFoodConsumedInPastDuration(this.horse.getId(), duration);
    }

    public Optional<Duration> getDurationSinceFoodLastConsumed() {
        return horseProvisionSession.getDurationSinceHorseLastAte(this.horse);
    }

    public double getGramsOfDrinkConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfDrinkConsumedInPastDuration(this.horse.getId(), duration);
    }

    public double getGramsOfExpiredDrinkConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfExpiredDrinkConsumedInPastDuration(this.horse.getId(), duration);
    }

    public double getGramsOfSpoiledDrinkConsumedInPastDuration(Duration duration) {
        return horseProvisionSession.getGramsOfSpoiledDrinkConsumedInPastDuration(this.horse.getId(), duration);
    }

    public Optional<Duration> getDurationSinceDrinkLastConsumed() {
        return horseProvisionSession.getDurationSinceHorseLastDrank(this.horse);
    }

    public void giveGramsOfFood(double grams) {
        horseProvisionGiveSession.giveGramsOfType(ProvisionType.FOOD, this.horse, grams);
        this.fullnessValue.expire();
    }

    public void takeGramsOfFood(double grams) {
        horseProvisionGiveSession.takeGramsOfType(ProvisionType.FOOD, this.horse, grams);
        this.fullnessValue.expire();
    }

    public void giveGramsOfDrink(double grams) {
        horseProvisionGiveSession.giveGramsOfType(ProvisionType.DRINK, this.horse, grams);
        this.hydrationValue.expire();
    }

    public void takeGramsOfDrink(double grams) {
        horseProvisionGiveSession.takeGramsOfType(ProvisionType.DRINK, this.horse, grams);
    }

    public boolean giveProvision(UUID provisionUuid, ECPlayer givingPlayer, double units) throws ProvisionGiveException {
        boolean taken = horseProvisionGiveSession.giveProvision(provisionUuid, this.horse, givingPlayer, units);
        if (taken) {
            this.fullnessValue.expire();
            this.hydrationValue.expire();
        }
        return taken;
    }

    public boolean giveProvision(ProvisionContainerInfo provision, double units) {
        boolean taken = horseProvisionGiveSession.giveProvision(provision, this.horse, units);
        if (taken) {
            this.fullnessValue.expire();
            this.hydrationValue.expire();
        }
        return taken;
    }

    private double getUpdatedFullnessValue() {
        return horseProvisionSession.getFullnessPercentage(this.horse);
    }

    private double getUpdatedHydrationValue() {
        return horseProvisionSession.getHydrationPercentage(this.horse);
    }
}

