/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision;

import com.equestricraft.base.eventbus.ECEventBus;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.HorseActionType;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.common.TrustAction;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.common.util.ListUtils;
import com.equestricraft.common.util.NumberUtils;
import com.equestricraft.common.util.PercentageUtils;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.agesetting.ProvisionScaleAge;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.action.ActionReaction;
import com.equestricraft.core.horse.action.HorseAction;
import com.equestricraft.core.horse.action.HorseActionExecutePayload;
import com.equestricraft.core.horse.nutrient.DefaultNutrientValueMapping;
import com.equestricraft.core.horse.nutrient.HorseNutritionUpdateSession;
import com.equestricraft.core.horse.nutrient.NutrientValueMapping;
import com.equestricraft.core.horse.provision.HorseProvisionGiveEvent;
import com.equestricraft.core.horse.provision.HorseProvisionGiveSession;
import com.equestricraft.core.horse.provision.HorseProvisionSession;
import com.equestricraft.core.horse.provision.ProvisionContainerInfo;
import com.equestricraft.core.horse.provision.ProvisionGiveException;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLog;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLogRepository;
import com.equestricraft.core.item.ItemTag;
import com.equestricraft.core.player.ECPlayer;
import com.equestricraft.core.player.provision.ProvisionInventoryItem;
import com.equestricraft.core.player.provision.ProvisionInventoryItemRepository;
import com.equestricraft.core.player.provision.ProvisionInventoryItemSession;
import com.equestricraft.core.provision.Provision;
import com.equestricraft.core.provision.ProvisionNutrient;
import com.equestricraft.core.provision.ProvisionRepository;
import java.util.Date;
import java.util.List;
import java.util.UUID;

public class HorseProvisionGiveSessionImpl
implements HorseProvisionGiveSession {
    @Service
    private ProvisionRepository provisionRepository;
    @Service
    private ProvisionInventoryItemRepository provisionInventoryItemRepository;
    @Service
    private ProvisionInventoryItemSession provisionInventoryItemSession;
    @Service
    private HorseNutritionUpdateSession horseNutritionUpdateSession;
    @Service
    private ProvisionHorseLogRepository provisionHorseLogRepository;
    @Service
    private AgeSettingSession ageSettingSession;
    @Service
    private HorseProvisionSession horseProvisionSession;

    @Override
    public boolean giveProvision(UUID provisionUuid, EQHorse horse, ECPlayer givingPlayer, double units) throws ProvisionGiveException {
        ProvisionInventoryItem inventoryItem = (ProvisionInventoryItem)this.provisionInventoryItemRepository.findByKey(provisionUuid);
        if (inventoryItem.getUnitsRemaining() < units) {
            throw new ProvisionGiveException(I18n.getLabel("horse.provision.give.not-enough"));
        }
        Provision provision = (Provision)this.provisionRepository.findByKey(inventoryItem.getProvisionId());
        if (!provision.isDivisible() && !NumberUtils.isWholeNumber(units)) {
            throw new IllegalArgumentException("Provision is not divisible");
        }
        HorseProvisionGiveEvent event = new HorseProvisionGiveEvent(horse, givingPlayer, provision.getId(), provision.getName(), provision.getProvisionType(), units);
        boolean cancelled = ECEventBus.post(event);
        if (cancelled) {
            return false;
        }
        HandFeedAction action = new HandFeedAction(horse, inventoryItem, provision, units, givingPlayer);
        return ((ActionReaction)horse.getActions().processAction(action)).isRejectAction();
    }

    public boolean shouldHorseAccept(double grams, ProvisionType type, EQHorse horse) {
        double currentState = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ProvisionType.FOOD -> this.horseProvisionSession.getFullnessPercentageWithOffset(horse, grams);
            case ProvisionType.DRINK -> this.horseProvisionSession.getHydrationPercentageWithOffset(horse, grams);
        };
        return currentState <= 120.0;
    }

    @Override
    public boolean giveProvision(ProvisionContainerInfo provisionContainerInfo, EQHorse horse, double units) {
        int percentage;
        Provision provision = (Provision)this.provisionRepository.findByKey(provisionContainerInfo.provisionId());
        if (!provision.isDivisible() && !NumberUtils.isWholeNumber(units)) {
            throw new IllegalArgumentException("Provision is not divisible");
        }
        HorseProvisionGiveEvent event = new HorseProvisionGiveEvent(horse, null, provision.getId(), provision.getName(), provision.getProvisionType(), units);
        boolean cancelled = ECEventBus.post(event);
        if (cancelled) {
            return false;
        }
        int n = percentage = provisionContainerInfo.spoiled() ? 100 : this.getPercentageThroughExpiryTime(provision, provisionContainerInfo.age());
        if (ListUtils.isNotEmpty(provision.getProvisionNutrients())) {
            List<DefaultNutrientValueMapping> updates = provision.getProvisionNutrients().stream().map(pn -> this.buildValueMapping((ProvisionNutrient)pn, percentage)).toList();
            this.horseNutritionUpdateSession.giveNutrientsToHorse(horse.getId(), updates);
        }
        this.updateLastTime(horse, provision);
        double grams = units * provision.getGramsPerUnit();
        boolean expired = provisionContainerInfo.age() >= (long)provision.getExpiryStartDays().intValue() * 86400000L;
        this.logProvisionConsumed(provision, horse, grams, expired, provisionContainerInfo.spoiled());
        return true;
    }

    @Override
    public void initialiseProvisionForHorse(EQHorse horse) {
        ProvisionScaleAge provisionScale = this.ageSettingSession.getProvisionScale(horse);
        double target = PercentageUtils.of(provisionScale.size(), 90);
        this.simulateProvisionConsumed(ProvisionType.FOOD, horse, target);
        this.simulateProvisionConsumed(ProvisionType.DRINK, horse, target);
    }

    @Override
    public void giveGramsOfType(ProvisionType provisionType, EQHorse horse, double grams) {
        if (grams < 0.0) {
            throw new IllegalArgumentException("Grams must not be less than zero");
        }
        this.simulateProvisionConsumed(provisionType, horse, grams);
    }

    @Override
    public void takeGramsOfType(ProvisionType provisionType, EQHorse horse, double grams) {
        if (grams < 0.0) {
            throw new IllegalArgumentException("Grams must not be less than zero");
        }
        this.simulateProvisionConsumed(provisionType, horse, -grams);
    }

    private void simulateProvisionConsumed(ProvisionType provisionType, EQHorse horse, double grams) {
        ProvisionHorseLog newLog = new ProvisionHorseLog(0, null, horse.getId(), System.currentTimeMillis(), grams, provisionType, false, false);
        this.provisionHorseLogRepository.add(newLog);
    }

    private int getPercentageThroughExpiryTime(Provision provision, long age) {
        if (provision.getExpiryStartDays() == null || provision.getExpiryEndDays() == null) {
            return 0;
        }
        if (age < (long)provision.getExpiryStartDays().intValue() * 86400000L) {
            return 0;
        }
        if (age > (long)provision.getExpiryEndDays().intValue() * 86400000L) {
            return 100;
        }
        long durationIntoExpiry = age - (long)provision.getExpiryStartDays().intValue() * 86400000L;
        long expiryDuration = (long)(provision.getExpiryEndDays() - provision.getExpiryStartDays()) * 86400000L;
        return (int)((expiryDuration - durationIntoExpiry) * 100L);
    }

    private DefaultNutrientValueMapping buildValueMapping(ProvisionNutrient pn, int percentage) {
        double delta = pn.getValue() - pn.getValueReduced();
        double toReduce = PercentageUtils.of(delta, percentage);
        double value = pn.getValue() - toReduce;
        return new DefaultNutrientValueMapping(pn.getNutrient(), value);
    }

    private void updateLastTime(EQHorse horse, Provision provision) {
        if (provision.getProvisionType() == ProvisionType.FOOD) {
            horse.setLastFeedTimeStamp(new Date());
        } else if (provision.getProvisionType() == ProvisionType.DRINK) {
            horse.setLastDrinkTimeStamp(new Date());
        } else {
            throw new IllegalArgumentException(String.format("Invalid provision type: %s", provision.getProvisionType().name()));
        }
        horse.save();
    }

    private void logProvisionConsumed(Provision provision, EQHorse horse, double grams, boolean expired, boolean bad) {
        ProvisionHorseLog newLog = new ProvisionHorseLog(0, provision.getId(), horse.getId(), System.currentTimeMillis(), grams, provision.getProvisionType(), expired, bad);
        this.provisionHorseLogRepository.add(newLog);
    }

    public class HandFeedAction
    extends HorseAction<ActionReaction> {
        private final ProvisionInventoryItem inventoryItem;
        private final Provision provision;
        private final double units;
        private boolean result;

        public HandFeedAction(EQHorse horse, ProvisionInventoryItem inventoryItem, Provision provision, double units, ECPlayer givingPlayer) {
            super(horse, givingPlayer);
            this.result = false;
            this.inventoryItem = inventoryItem;
            this.provision = provision;
            this.units = units;
        }

        @Override
        protected boolean affectsTack() {
            return true;
        }

        @Override
        public HorseActionType getType() {
            return HorseActionType.HAND_FEED;
        }

        @Override
        protected List<ItemTag> getTags() {
            return this.provision.getTags();
        }

        @Override
        public void execute(HorseActionExecutePayload payload) {
            int percentage;
            double grams = this.units * this.provision.getGramsPerUnit();
            if (!HorseProvisionGiveSessionImpl.this.shouldHorseAccept(grams, this.provision.getProvisionType(), this.horse)) {
                return;
            }
            int n = percentage = this.inventoryItem.isSpoiled() ? 100 : this.getPercentageThroughExpiry(this.inventoryItem);
            if (ListUtils.isNotEmpty(this.provision.getProvisionNutrients())) {
                List<DefaultNutrientValueMapping> updates = this.provision.getProvisionNutrients().stream().map(pn -> HorseProvisionGiveSessionImpl.this.buildValueMapping((ProvisionNutrient)pn, percentage)).toList();
                HorseProvisionGiveSessionImpl.this.horseNutritionUpdateSession.giveNutrientsToHorse(this.horse.getId(), (List<? extends NutrientValueMapping>)updates);
            }
            for (ItemTag tag : this.provision.getTags()) {
                double value;
                if (tag.getRejectThreshold() == null || !((value = this.horse.getTags().getValueForTag(tag.getTagId())) <= tag.getRejectThreshold())) continue;
                return;
            }
            if (this.performingPlayer != null) {
                HorseProvisionGiveSessionImpl.this.provisionInventoryItemSession.removeItemFromInventory(this.inventoryItem.getUuid(), this.units);
            }
            HorseProvisionGiveSessionImpl.this.updateLastTime(this.horse, this.provision);
            boolean expired = this.hasStartedExpiry(this.inventoryItem);
            HorseProvisionGiveSessionImpl.this.logProvisionConsumed(this.provision, this.horse, grams, expired, this.inventoryItem.isSpoiled());
            if (this.performingPlayer != null) {
                this.horse.getTrust().processAction(this.performingPlayer, TrustAction.PROVISION_GIVE);
            }
            for (ItemTag tag : this.provision.getTags()) {
                payload.addTagUpdate(tag.getTagId(), tag.getOffsetValue());
            }
            this.result = true;
        }

        private int getPercentageThroughExpiry(ProvisionInventoryItem inventoryItem) {
            if (!this.hasStartedExpiry(inventoryItem)) {
                return 0;
            }
            if (this.hasFinishedExpiry(inventoryItem)) {
                return 100;
            }
            long duration = inventoryItem.getEndExpiryTime() - inventoryItem.getStartExpiryTime();
            long durationIntoTime = System.currentTimeMillis() - inventoryItem.getStartExpiryTime();
            float value = (float)((double)durationIntoTime / (double)duration);
            return (int)(value * 100.0f);
        }

        private boolean hasStartedExpiry(ProvisionInventoryItem provisionInventoryItem) {
            return provisionInventoryItem.getStartExpiryTime() != null && DateUtils.isInPast(provisionInventoryItem.getStartExpiryTime());
        }

        public boolean hasFinishedExpiry(ProvisionInventoryItem provisionInventoryItem) {
            return provisionInventoryItem.getEndExpiryTime() != null && DateUtils.isInPast(provisionInventoryItem.getEndExpiryTime());
        }

        @Override
        public ActionReaction buildReaction(boolean reject) {
            return new ActionReaction(this.result);
        }

        @Override
        public String getIdentifier() {
            return "hand_feed";
        }
    }
}

