/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.common.util.DateUtils;
import com.equestricraft.core.agesetting.AgeSettingSession;
import com.equestricraft.core.agesetting.ProvisionScaleAge;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.provision.HorseProvisionSession;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLog;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLogRepository;
import java.time.Duration;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public class HorseProvisionSessionImpl
implements HorseProvisionSession {
    @Service
    private ProvisionHorseLogRepository provisionHorseLogRepository;
    @Service
    private AgeSettingSession ageSettingSession;

    @Override
    public Optional<Duration> getDurationSinceHorseLastAte(EQHorse horse) {
        Date lastEat = horse.getLastFeedTimeStamp();
        if (lastEat == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationSince(lastEat));
    }

    @Override
    public Optional<Duration> getDurationSinceHorseLastDrank(EQHorse horse) {
        Date lastDrink = horse.getLastDrinkTimeStamp();
        if (lastDrink == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(DateUtils.durationSince(lastDrink));
    }

    @Override
    public double getGramsOfFoodConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfTypeConsumedInPastDuration(horseId, duration, ProvisionType.FOOD);
    }

    @Override
    public double getGramsOfExpiredFoodConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfExpiredTypeConsumedInPastDuration(horseId, duration, ProvisionType.FOOD);
    }

    @Override
    public double getGramsOfSpoiledFoodConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfSpoiledTypeConsumedInPastDuration(horseId, duration, ProvisionType.FOOD);
    }

    @Override
    public double getGramsOfDrinkConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfTypeConsumedInPastDuration(horseId, duration, ProvisionType.DRINK);
    }

    @Override
    public double getGramsOfExpiredDrinkConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfExpiredTypeConsumedInPastDuration(horseId, duration, ProvisionType.DRINK);
    }

    @Override
    public double getGramsOfSpoiledDrinkConsumedInPastDuration(int horseId, Duration duration) {
        return this.getGramsOfSpoiledTypeConsumedInPastDuration(horseId, duration, ProvisionType.DRINK);
    }

    private double getGramsOfTypeConsumedInPastDuration(int horseId, Duration duration, ProvisionType type) {
        return this.getGramsOfTypeConsumedInPastDuration(horseId, duration, type, this::wasProvisionGood);
    }

    private double getGramsOfExpiredTypeConsumedInPastDuration(int horseId, Duration duration, ProvisionType type) {
        return this.getGramsOfTypeConsumedInPastDuration(horseId, duration, type, ProvisionHorseLog::isWasExpired);
    }

    private double getGramsOfSpoiledTypeConsumedInPastDuration(int horseId, Duration duration, ProvisionType type) {
        return this.getGramsOfTypeConsumedInPastDuration(horseId, duration, type, ProvisionHorseLog::isWasSpoiled);
    }

    private double getGramsOfTypeConsumedInPastDuration(int horseId, Duration duration, ProvisionType type, Predicate<ProvisionHorseLog> predicate) {
        Date time = DateUtils.futureDurationOffset(duration.negated());
        List<ProvisionHorseLog> logs = this.provisionHorseLogRepository.findAllLogsOfTypeForHorseSinceTime(type, horseId, time.getTime());
        return logs.stream().filter(predicate).mapToDouble(ProvisionHorseLog::getGrams).sum();
    }

    private boolean wasProvisionGood(ProvisionHorseLog l) {
        return !l.isWasExpired() && !l.isWasSpoiled();
    }

    @Override
    public double getFullnessPercentage(EQHorse horse) {
        return this.getFullnessPercentageWithOffset(horse, 0.0);
    }

    @Override
    public double getFullnessPercentageWithOffset(EQHorse horse, double grams) {
        ProvisionScaleAge ageSettings = this.ageSettingSession.getProvisionScale(horse);
        Duration duration = Duration.ofHours((long)ageSettings.hours());
        double gramsConsumed = this.getGramsOfFoodConsumedInPastDuration(horse.getId(), duration);
        return (gramsConsumed + grams) / ageSettings.size() * 100.0;
    }

    @Override
    public double getHydrationPercentage(EQHorse horse) {
        return this.getHydrationPercentageWithOffset(horse, 0.0);
    }

    @Override
    public double getHydrationPercentageWithOffset(EQHorse horse, double grams) {
        ProvisionScaleAge ageSettings = this.ageSettingSession.getProvisionScale(horse);
        Duration duration = Duration.ofHours((long)ageSettings.hours());
        double gramsConsumed = this.getGramsOfDrinkConsumedInPastDuration(horse.getId(), duration);
        return (gramsConsumed + grams) / ageSettings.size() * 100.0;
    }
}

