/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision.log;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLog;
import java.util.List;

public class ProvisionHorseLogDatabase
implements RepositoryDatasource<ProvisionHorseLog, Integer> {
    private static final String COLUMN_ID = "ID";
    private static final String COLUMN_PROVISION_ID = "PROVISION_ID";
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_TIME_STAMP = "TIME_STAMP";
    private static final String COLUMN_GRAMS = "GRAMS";
    private static final String COLUMN_TYPE = "TYPE";
    private static final String COLUMN_WAS_EXPIRED = "WAS_EXPIRED";
    private static final String COLUMN_WAS_SPOILED = "WAS_SPOILED";

    @Override
    public void create(ProvisionHorseLog provisionHorseLog) {
        Query.insertInto("PROVISION_HORSE_LOG").columns(QueryColumn.column(COLUMN_PROVISION_ID, provisionHorseLog.getProvisionId()), QueryColumn.column(COLUMN_HORSE_ID, provisionHorseLog.getHorseId()), QueryColumn.column(COLUMN_TIME_STAMP, provisionHorseLog.getTimeStamp()), QueryColumn.column(COLUMN_GRAMS, provisionHorseLog.getGrams()), QueryColumn.column(COLUMN_TYPE, provisionHorseLog.getType()), QueryColumn.column(COLUMN_WAS_EXPIRED, provisionHorseLog.isWasExpired()), QueryColumn.column(COLUMN_WAS_SPOILED, provisionHorseLog.isWasSpoiled())).executeGetGeneratedKey(provisionHorseLog::setId);
    }

    @Override
    public List<ProvisionHorseLog> retrieveAll() {
        return Query.selectAllFrom("PROVISION_HORSE_LOG").getList(this::getFromResultRow);
    }

    private ProvisionHorseLog getFromResultRow(ResultRow row) {
        int id = row.getInt(COLUMN_ID);
        Integer provisionId = row.getNullableInt(COLUMN_PROVISION_ID);
        int horseId = row.getInt(COLUMN_HORSE_ID);
        long timeStamp = row.getLong(COLUMN_TIME_STAMP);
        double grams = row.getDouble(COLUMN_GRAMS);
        ProvisionType type = row.getEnum(COLUMN_TYPE, ProvisionType.class);
        boolean wasExpired = row.getBoolean(COLUMN_WAS_EXPIRED);
        boolean wasSpoiled = row.getBoolean(COLUMN_WAS_SPOILED);
        return new ProvisionHorseLog(id, provisionId, horseId, timeStamp, grams, type, wasExpired, wasSpoiled);
    }
}

