/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.provision.log;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.cdi.Service;
import com.equestricraft.common.ProvisionType;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLog;
import com.equestricraft.core.horse.provision.log.ProvisionHorseLogDatabase;
import java.util.List;

public class ProvisionHorseLogRepository
extends Repository<ProvisionHorseLog, Integer> {
    @Service
    private ProvisionHorseLogDatabase provisionHorseLogDatabase;

    @Override
    protected RepositoryDatasource<ProvisionHorseLog, Integer> getDatasource() {
        return this.provisionHorseLogDatabase;
    }

    public List<ProvisionHorseLog> findExpiredByHorseSinceTime(int horseId, long time) {
        return this.findListByPredicates(ProvisionHorseLog::isWasExpired, l -> l.getHorseId() == horseId, l -> l.getTimeStamp() >= time);
    }

    public List<ProvisionHorseLog> findSpoiledByHorseSinceTime(int horseId, long time) {
        return this.findListByPredicates(ProvisionHorseLog::isWasExpired, l -> l.getHorseId() == horseId, l -> l.getTimeStamp() >= time);
    }

    public List<ProvisionHorseLog> findAllLogsOfTypeForHorseSinceTime(ProvisionType type, int horseId, long time) {
        return this.findListByPredicates(l -> l.getType().equals((Object)type), l -> l.getHorseId() == horseId, l -> l.getTimeStamp() >= time);
    }
}

