/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.proximity;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.coordinate.DirectionalCoordinate;
import com.equestricraft.common.util.LocationUtils;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.proximity.HorseProximityService;
import java.util.Collections;
import java.util.List;

public class HorseProximityServiceImpl
implements HorseProximityService {
    @Service
    private HorseRepository horseRepository;

    @Override
    public List<EQHorse> getAliveHorsesInRange(EQHorse baseHorse, int range) {
        List<EQHorse> aliveHorses = this.horseRepository.findAllLivingHorses();
        return this.getHorsesInRange(baseHorse, range, aliveHorses);
    }

    private List<EQHorse> getHorsesInRange(EQHorse baseHorse, int range, List<EQHorse> horsesToCheckAgainst) {
        DirectionalCoordinate baseHorseLocation = baseHorse.getDirectionalCoordinate();
        if (baseHorseLocation == null) {
            return Collections.emptyList();
        }
        horsesToCheckAgainst.removeIf(baseHorse::equals);
        if (horsesToCheckAgainst.isEmpty()) {
            return Collections.emptyList();
        }
        List<HorseLocationSnapshot> locationSnapshotList = this.transformHorseListToLocationSnapshotList(horsesToCheckAgainst);
        return locationSnapshotList.stream().filter(l -> l.location().world().equals(baseHorseLocation.world())).map(l -> this.createProximityInfo(baseHorseLocation, (HorseLocationSnapshot)l)).filter(i -> i.distance <= (double)range).map(ProximityInfo::horse).toList();
    }

    private List<HorseLocationSnapshot> transformHorseListToLocationSnapshotList(List<EQHorse> horses) {
        return horses.stream().map(this::transformHorseToLocationSnapshot).toList();
    }

    private HorseLocationSnapshot transformHorseToLocationSnapshot(EQHorse horse) {
        return new HorseLocationSnapshot(horse, horse.getDirectionalCoordinate());
    }

    private ProximityInfo createProximityInfo(DirectionalCoordinate baseLocation, HorseLocationSnapshot locationSnapshot) {
        double distance = LocationUtils.calculateDistance(baseLocation, locationSnapshot.location());
        return new ProximityInfo(locationSnapshot.horse(), distance);
    }

    private record HorseLocationSnapshot(EQHorse horse, DirectionalCoordinate location) {
    }

    private record ProximityInfo(EQHorse horse, double distance) {
    }
}

