/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.registration;

import com.equestricraft.base.repository.RepositoryEntity;
import com.equestricraft.cdi.Services;
import com.equestricraft.core.horse.registration.HorseRegistrationRepository;
import java.util.Objects;

public class HorseRegistration
implements RepositoryEntity<Integer> {
    private final int horseId;
    private final int organizationId;
    private final int registrationNumber;
    private final long registrationDate;
    private final String showName;
    private final int showNameNumber;
    private final int registeredByPlayerId;

    public HorseRegistration(int horseId, int organizationId, int registrationNumber, long registrationDate, String showName, int showNameNumber, int registeredByPlayerId) {
        this.horseId = horseId;
        this.organizationId = organizationId;
        this.registrationNumber = registrationNumber;
        this.registrationDate = registrationDate;
        this.showName = showName;
        this.showNameNumber = showNameNumber;
        this.registeredByPlayerId = registeredByPlayerId;
    }

    @Override
    public Integer getKey() {
        return this.getHorseId();
    }

    public int getHorseId() {
        return this.horseId;
    }

    public int getOrganizationId() {
        return this.organizationId;
    }

    public int getRegistrationNumber() {
        return this.registrationNumber;
    }

    public long getRegistrationDate() {
        return this.registrationDate;
    }

    public String getShowName() {
        return this.showName;
    }

    public int getShowNameNumber() {
        return this.showNameNumber;
    }

    public int getRegisteredByPlayerId() {
        return this.registeredByPlayerId;
    }

    @Override
    public void save() {
        Services.getService(HorseRegistrationRepository.class).update(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HorseRegistration that = (HorseRegistration)o;
        return this.horseId == that.horseId;
    }

    public int hashCode() {
        return Objects.hash(this.horseId);
    }
}

