/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.registration;

import com.equestricraft.base.database.Query;
import com.equestricraft.base.database.QueryColumn;
import com.equestricraft.base.database.ResultRow;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.core.horse.registration.HorseRegistration;
import java.util.List;

public class HorseRegistrationDatabase
implements RepositoryDatasource<HorseRegistration, Integer> {
    private static final String COLUMN_HORSE_ID = "HORSE_ID";
    private static final String COLUMN_ORGANIZATION_ID = "ORGANIZATION_ID";
    private static final String COLUMN_REGISTRATION_NUMBER = "REGISTRATION_NUMBER";
    private static final String COLUMN_REGISTRATION_DATE = "REGISTRATION_DATE";
    private static final String COLUMN_SHOW_NAME = "SHOW_NAME";
    private static final String COLUMN_SHOW_NAME_NUMBER = "SHOW_NAME_NUMBER";
    private static final String COLUMN_REGISTERED_BY_PLAYER_ID = "REGISTERED_BY_PLAYER_ID";

    @Override
    public void create(HorseRegistration horseRegistration) {
        Query.insertInto("HORSE_REGISTRATION").columns(QueryColumn.column(COLUMN_HORSE_ID, horseRegistration.getHorseId()), QueryColumn.column(COLUMN_ORGANIZATION_ID, horseRegistration.getOrganizationId()), QueryColumn.column(COLUMN_REGISTRATION_NUMBER, horseRegistration.getRegistrationNumber()), QueryColumn.column(COLUMN_REGISTRATION_DATE, horseRegistration.getRegistrationDate()), QueryColumn.column(COLUMN_SHOW_NAME, horseRegistration.getShowName()), QueryColumn.column(COLUMN_SHOW_NAME_NUMBER, horseRegistration.getShowNameNumber()), QueryColumn.column(COLUMN_REGISTERED_BY_PLAYER_ID, horseRegistration.getRegisteredByPlayerId())).execute();
    }

    @Override
    public List<HorseRegistration> retrieveAll() {
        return Query.selectAllFrom("HORSE_REGISTRATION").getList(this::getFromResultRow);
    }

    @Override
    public void update(HorseRegistration horseRegistration) {
        Query.update("HORSE_REGISTRATION").set(QueryColumn.column(COLUMN_SHOW_NAME, horseRegistration.getShowName())).where(QueryColumn.column(COLUMN_HORSE_ID, horseRegistration.getHorseId())).execute();
    }

    private HorseRegistration getFromResultRow(ResultRow row) {
        int horseId = row.getInt(COLUMN_HORSE_ID);
        int organizationId = row.getInt(COLUMN_ORGANIZATION_ID);
        int registrationNumber = row.getInt(COLUMN_REGISTRATION_NUMBER);
        long registrationDate = row.getLong(COLUMN_REGISTRATION_DATE);
        String showName = row.getString(COLUMN_SHOW_NAME);
        int showNameNumber = row.getInt(COLUMN_SHOW_NAME_NUMBER);
        int registeredByPlayerId = row.getInt(COLUMN_REGISTERED_BY_PLAYER_ID);
        return new HorseRegistration(horseId, organizationId, registrationNumber, registrationDate, showName, showNameNumber, registeredByPlayerId);
    }
}

