/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.registration;

import com.equestricraft.base.repository.Repository;
import com.equestricraft.base.repository.RepositoryDatasource;
import com.equestricraft.base.repository.RepositorySearchQuery;
import com.equestricraft.cdi.Service;
import com.equestricraft.core.horse.registration.HorseRegistration;
import com.equestricraft.core.horse.registration.HorseRegistrationDatabase;
import java.util.Optional;

public class HorseRegistrationRepository
extends Repository<HorseRegistration, Integer> {
    @Service
    private HorseRegistrationDatabase horseRegistrationDatabase;

    @Override
    protected RepositoryDatasource<HorseRegistration, Integer> getDatasource() {
        return this.horseRegistrationDatabase;
    }

    public int findCountWithBaseShowName(String showName) {
        RepositorySearchQuery<HorseRegistration> query = this.createSearchQuery();
        query.filter(r -> r.getShowName().equals(showName));
        return Math.toIntExact(query.count());
    }

    public Optional<HorseRegistration> findByOrganisationAndIdNumber(int organisationId, int idNumber) {
        return this.findSingleByPredicates(r -> r.getOrganizationId() == organisationId, r -> r.getRegistrationNumber() == idNumber);
    }
}

