/*
 * Decompiled with CFR 0.152.
 */
package com.equestricraft.core.horse.registration;

import com.equestricraft.cdi.Service;
import com.equestricraft.common.ColorsHelper;
import com.equestricraft.common.StringCheck;
import com.equestricraft.common.i18n.I18n;
import com.equestricraft.common.romannumeral.RomanNumeral;
import com.equestricraft.common.romannumeral.RomanNumeralDigit;
import com.equestricraft.common.romannumeral.RomanNumeralUtil;
import com.equestricraft.common.util.StringUtils;
import com.equestricraft.core.blockedphrase.BlockedPhraseService;
import com.equestricraft.core.economy.EconomyException;
import com.equestricraft.core.horse.APIHorseDtoImpl;
import com.equestricraft.core.horse.EQHorse;
import com.equestricraft.core.horse.HorseConstants;
import com.equestricraft.core.horse.HorseRepository;
import com.equestricraft.core.horse.registration.HorseRegistration;
import com.equestricraft.core.horse.registration.HorseRegistrationCertificateDetails;
import com.equestricraft.core.horse.registration.HorseRegistrationException;
import com.equestricraft.core.horse.registration.HorseRegistrationInfo;
import com.equestricraft.core.horse.registration.HorseRegistrationRepository;
import com.equestricraft.core.horse.registration.HorseRegistrationResponse;
import com.equestricraft.core.horse.registration.HorseRegistrationSession;
import com.equestricraft.core.player.CorePlayer;
import com.equestricraft.core.player.PlayerRepository;
import com.equestricraft.core.player.PlayerTransformer;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganization;
import com.equestricraft.core.registrationorganization.HorseRegistrationOrganizationRepository;
import com.equestricraft.core.registrationorganization.OrganizationInfo;
import com.equestricraft.groovy.GroovyException;
import com.equestricraft.groovy.executor.GroovyRuleScriptExecutor;
import com.equestricraft.groovy.executor.RuleScriptResponse;
import com.equestricraft.logging.Log;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class HorseRegistrationSessionImpl
implements HorseRegistrationSession {
    @Service
    private HorseRegistrationOrganizationRepository horseRegistrationOrganizationRepository;
    @Service
    private HorseRegistrationRepository horseRegistrationRepository;
    @Service
    private HorseRepository horseRepository;
    @Service
    private BlockedPhraseService blockedPhraseService;
    @Service
    private PlayerRepository playerRepository;
    @Service
    private PlayerTransformer playerTransformer;
    private final Object lock = new Object();
    private static final Log log = Log.getLogger(HorseRegistrationSessionImpl.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HorseRegistrationResponse registerHorseWithOrganization(EQHorse horse, int organizationId, String showName) throws EconomyException, HorseRegistrationException {
        Objects.requireNonNull(showName, "Must provide a show name");
        this.ensureHorseNotAlreadyRegistered(horse);
        showName = showName.trim();
        showName = ColorsHelper.stripColorsAndFormatting(showName);
        showName = StringUtils.removeExtraSpaces(showName);
        this.ensureShowNameValid(showName);
        HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(organizationId);
        this.ensureConditionCheckPasses(organization, horse);
        horse.getOwner().getEconomy().withdraw(organization.getPrice(), I18n.getLabel("horse.registration-office.economy-transaction", horse.getName(), organization.getName()), "Horse Registration");
        Object object = this.lock;
        synchronized (object) {
            int number = this.getNextNumberForShowName(showName);
            HorseRegistration registration = new HorseRegistration(horse.getId(), organization.getId(), organization.getNextRegistrationNumber(), System.currentTimeMillis(), showName, number, horse.getOwnerId());
            registration = this.horseRegistrationRepository.add(registration);
            organization.setNextRegistrationNumber(organization.getNextRegistrationNumber() + 1);
            organization.save();
            String registrationNumber = this.buildRegistrationNumber(organization, registration);
            String finalShowName = this.buildShowName(registration);
            return new HorseRegistrationResponse(registrationNumber, finalShowName);
        }
    }

    @Override
    public String getPossibleShowName(String showName) {
        int number = this.getNextNumberForShowName((String)showName);
        RomanNumeral numeral = new RomanNumeral(number);
        showName = StringUtils.capitaliseString((String)showName) + " " + numeral.getNumeralValue();
        return this.normaliseShowName((String)showName);
    }

    @Override
    public Optional<HorseRegistrationOrganization> getHorsesOrganization(EQHorse horse) {
        Optional registration = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        if (registration.isPresent()) {
            HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(((HorseRegistration)registration.get()).getOrganizationId());
            return Optional.ofNullable(organization);
        }
        return Optional.empty();
    }

    private void ensureHorseNotAlreadyRegistered(EQHorse horse) throws HorseRegistrationException {
        Optional existingRegistration = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        if (existingRegistration.isPresent()) {
            HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(((HorseRegistration)existingRegistration.get()).getOrganizationId());
            throw new HorseRegistrationException(I18n.getLabel("horse.registration-office.already-registered", organization.getName()));
        }
    }

    private void ensureShowNameValid(String showName) throws HorseRegistrationException {
        if (showName.isBlank()) {
            throw new HorseRegistrationException(I18n.getLabel("horse.show-name.validation.no-value"));
        }
        if (showName.length() > HorseConstants.MAXIMUM_SHOW_NAME_LENGTH) {
            throw new HorseRegistrationException(I18n.getLabel("horse.show-name.validation.too-long", HorseConstants.MAXIMUM_SHOW_NAME_LENGTH));
        }
        if (!StringCheck.isAlphabeticAllowSpaces(showName)) {
            throw new HorseRegistrationException(I18n.getLabel("horse.show-name.validation.invalid-character"));
        }
        if (this.hasRomanNumeralSuffix(showName)) {
            throw new HorseRegistrationException(I18n.getLabel("horse.show-name.validation.no-numerals-suffix"));
        }
        if (this.blockedPhraseService.containsBlockedPhrase(showName)) {
            throw new HorseRegistrationException(I18n.getLabel("horse.show-name.validation.blocked-phrase"));
        }
    }

    private boolean hasRomanNumeralSuffix(String showName) {
        String[] parts = showName.split(" ");
        if (parts.length <= 1) {
            return false;
        }
        String suffix = parts[parts.length - 1];
        return RomanNumeralUtil.isRomanNumerals(suffix);
    }

    private int getNextNumberForShowName(String showName) {
        int showNameCount = this.horseRegistrationRepository.findCountWithBaseShowName(showName);
        return showNameCount + 1;
    }

    private void ensureConditionCheckPasses(HorseRegistrationOrganization organization, EQHorse horse) throws HorseRegistrationException {
        if (organization.getConditionScript().isBlank()) {
            return;
        }
        APIHorseDtoImpl dto = new APIHorseDtoImpl(horse);
        try {
            RuleScriptResponse result = ((GroovyRuleScriptExecutor)GroovyRuleScriptExecutor.start(organization.getConditionScript()).withHorse(dto)).execute().result();
            if (Boolean.FALSE.equals(result.success())) {
                throw new HorseRegistrationException(result.promptRequest().getMessage(), result.promptRequest().getTitle());
            }
        }
        catch (GroovyException ex) {
            log.error("Error running script", ex);
        }
    }

    @Override
    public Optional<HorseRegistrationInfo> getHorsesRegistrationInfo(EQHorse horse) {
        Optional registrationForHorse = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        if (registrationForHorse.isPresent()) {
            HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(((HorseRegistration)registrationForHorse.get()).getOrganizationId());
            OrganizationInfo organizationInfo = new OrganizationInfo(organization.getId(), organization.getName(), organization.getDescription());
            CorePlayer registeringPlayer = (CorePlayer)this.playerRepository.findByKey(((HorseRegistration)registrationForHorse.get()).getRegisteredByPlayerId());
            HorseRegistrationInfo horseRegistrationInfo = new HorseRegistrationInfo(organizationInfo, horse, this.buildRegistrationNumber(organization, (HorseRegistration)registrationForHorse.get()), this.buildShowName((HorseRegistration)registrationForHorse.get()), new Date(((HorseRegistration)registrationForHorse.get()).getRegistrationDate()), registeringPlayer);
            return Optional.of(horseRegistrationInfo);
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> getHorsesRegistrationNumber(EQHorse horse) {
        Optional registrationForHorse = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        if (registrationForHorse.isPresent()) {
            HorseRegistrationOrganization organization = (HorseRegistrationOrganization)this.horseRegistrationOrganizationRepository.findByKey(((HorseRegistration)registrationForHorse.get()).getOrganizationId());
            String number = this.buildRegistrationNumber(organization, (HorseRegistration)registrationForHorse.get());
            return Optional.of(number);
        }
        return Optional.empty();
    }

    @Override
    public Optional<HorseRegistrationCertificateDetails> getHorsesRegistrationCertificateDetails(EQHorse horse) {
        Optional<HorseRegistrationInfo> infoOptional = this.getHorsesRegistrationInfo(horse);
        return infoOptional.map(info2 -> this.buildDetails(horse, (HorseRegistrationInfo)info2));
    }

    private HorseRegistrationCertificateDetails buildDetails(EQHorse horse, HorseRegistrationInfo info2) {
        String breed = horse.getBreed().getDisplayString();
        return new HorseRegistrationCertificateDetails(info2.organization(), info2.horse().getId(), info2.registrationNumber(), this.playerTransformer.toSimple(info2.horse().getOwner().getCorePlayer()), info2.showName(), info2.horse().getHorseGender(), info2.horse().getBirthTime(), info2.registrationDate(), this.playerTransformer.toSimple(info2.registeringPlayer().getCorePlayer()), breed);
    }

    private String buildRegistrationNumber(HorseRegistrationOrganization organization, HorseRegistration horseRegistration) {
        if (organization.getId() != horseRegistration.getOrganizationId()) {
            throw new IllegalArgumentException("Organization and registration do not match");
        }
        return String.format("%s-%06d", organization.getRegistrationNumberPrefix(), horseRegistration.getRegistrationNumber());
    }

    @Override
    public Optional<String> getHorsesShowName(EQHorse horse) {
        Optional<HorseRegistration> registrationForHorse = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        return registrationForHorse.map(this::buildShowName);
    }

    private String buildShowName(HorseRegistration horseRegistration) {
        RomanNumeral numeral = new RomanNumeral(horseRegistration.getShowNameNumber());
        String showName = StringUtils.capitaliseString(horseRegistration.getShowName()) + " " + numeral.getNumeralValue();
        return this.normaliseShowName(showName);
    }

    private String normaliseShowName(String showName) {
        if (showName.endsWith(" " + RomanNumeralDigit.I.name())) {
            return showName.substring(0, showName.length() - 2);
        }
        return showName;
    }

    @Override
    public boolean isRegistered(EQHorse horse) {
        Optional registrationForHorse = this.horseRegistrationRepository.findByKeyIfExists(horse.getId());
        return registrationForHorse.isPresent();
    }

    @Override
    public Optional<HorseRegistrationCertificateDetails> lookupHorseRegistration(String registrationNumber) {
        Optional<EQHorse> horse = this.findHorseByRegistrationNumber(registrationNumber);
        if (horse.isPresent()) {
            return this.getHorsesRegistrationCertificateDetails(horse.get());
        }
        return Optional.empty();
    }

    @Override
    public Optional<EQHorse> findHorseByRegistrationNumber(String registrationNumber) {
        try {
            Optional<HorseRegistration> registration;
            RegistrationNumber registrationNumberDetails = this.parseRegistrationNumber(registrationNumber);
            Optional<HorseRegistrationOrganization> organisation = this.horseRegistrationOrganizationRepository.findByPrefix(registrationNumberDetails.prefix());
            if (organisation.isPresent() && (registration = this.horseRegistrationRepository.findByOrganisationAndIdNumber(organisation.get().getId(), registrationNumberDetails.idNumber())).isPresent()) {
                EQHorse horse = (EQHorse)this.horseRepository.findByKey(registration.get().getHorseId());
                return Optional.of(horse);
            }
            return Optional.empty();
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private RegistrationNumber parseRegistrationNumber(String registrationNumber) {
        if (!registrationNumber.contains("-")) {
            throw new IllegalArgumentException();
        }
        String[] parts = registrationNumber.split("-");
        String prefix = parts[0];
        int idNumber = Integer.parseInt(parts[1]);
        return new RegistrationNumber(prefix, idNumber);
    }

    private record RegistrationNumber(String prefix, int idNumber) {
    }
}

